/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.mlt.MoreLikeThisRequest;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.client.transport.ClientTransportModule;
import org.elasticsearch.client.transport.TransportClientNodesService;
import org.elasticsearch.client.transport.support.InternalTransportClient;
import org.elasticsearch.cluster.ClusterNameModule;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.io.CachedStreams;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.EnvironmentModule;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.node.internal.InternalSettingsPerparer;
import org.elasticsearch.plugins.PluginsModule;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.search.TransportSearchModule;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolModule;
import org.elasticsearch.transport.TransportModule;
import org.elasticsearch.transport.TransportService;

public class TransportClient
extends AbstractClient {
    private final Injector injector;
    private final Settings settings;
    private final Environment environment;
    private final PluginsService pluginsService;
    private final TransportClientNodesService nodesService;
    private final InternalTransportClient internalClient;

    public TransportClient() throws ElasticSearchException {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, true);
    }

    public TransportClient(Settings settings) {
        this(settings, true);
    }

    public TransportClient(Settings.Builder settings) {
        this(settings.build(), true);
    }

    public TransportClient(Settings.Builder settings, boolean loadConfigSettings) throws ElasticSearchException {
        this(settings.build(), loadConfigSettings);
    }

    public TransportClient(Settings pSettings, boolean loadConfigSettings) throws ElasticSearchException {
        Tuple<Settings, Environment> tuple = InternalSettingsPerparer.prepareSettings(pSettings, loadConfigSettings);
        Settings settings = ImmutableSettings.settingsBuilder().put(tuple.v1()).put("network.server", false).put("node.client", true).build();
        this.environment = tuple.v2();
        this.pluginsService = new PluginsService(settings, tuple.v2());
        this.settings = this.pluginsService.updatedSettings();
        CompressorFactory.configure(this.settings);
        ModulesBuilder modules = new ModulesBuilder();
        modules.add((Module)new PluginsModule(this.settings, this.pluginsService));
        modules.add((Module)new EnvironmentModule(this.environment));
        modules.add((Module)new SettingsModule(this.settings));
        modules.add((Module)new NetworkModule());
        modules.add((Module)new ClusterNameModule(this.settings));
        modules.add((Module)new ThreadPoolModule(this.settings));
        modules.add((Module)new TransportSearchModule());
        modules.add((Module)new TransportModule(this.settings));
        modules.add((Module)new ActionModule(true));
        modules.add((Module)new ClientTransportModule());
        this.injector = modules.createInjector();
        this.injector.getInstance(TransportService.class).start();
        this.nodesService = this.injector.getInstance(TransportClientNodesService.class);
        this.internalClient = this.injector.getInstance(InternalTransportClient.class);
    }

    public ImmutableList<TransportAddress> transportAddresses() {
        return this.nodesService.transportAddresses();
    }

    public ImmutableList<DiscoveryNode> connectedNodes() {
        return this.nodesService.connectedNodes();
    }

    public ImmutableList<DiscoveryNode> listedNodes() {
        return this.nodesService.listedNodes();
    }

    public TransportClient addTransportAddress(TransportAddress transportAddress) {
        this.nodesService.addTransportAddresses(transportAddress);
        return this;
    }

    public TransportClient addTransportAddresses(TransportAddress ... transportAddress) {
        this.nodesService.addTransportAddresses(transportAddress);
        return this;
    }

    public TransportClient removeTransportAddress(TransportAddress transportAddress) {
        this.nodesService.removeTransportAddress(transportAddress);
        return this;
    }

    @Override
    public void close() {
        this.injector.getInstance(TransportClientNodesService.class).close();
        this.injector.getInstance(TransportService.class).close();
        try {
            this.injector.getInstance(MonitorService.class).close();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (Class<? extends LifecycleComponent> plugin : this.pluginsService.services()) {
            this.injector.getInstance(plugin).close();
        }
        this.injector.getInstance(ThreadPool.class).shutdown();
        try {
            this.injector.getInstance(ThreadPool.class).awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.injector.getInstance(ThreadPool.class).shutdownNow();
        }
        catch (Exception exception2) {
            // empty catch block
        }
        CacheRecycler.clear();
        CachedStreams.clear();
        ThreadLocals.clearReferencesThreadLocals();
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public ThreadPool threadPool() {
        return this.internalClient.threadPool();
    }

    @Override
    public AdminClient admin() {
        return this.internalClient.admin();
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder> action, Request request) {
        return this.internalClient.execute(action, request);
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void execute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        this.internalClient.execute(action, request, listener);
    }

    @Override
    public ActionFuture<IndexResponse> index(IndexRequest request) {
        return this.internalClient.index(request);
    }

    @Override
    public void index(IndexRequest request, ActionListener<IndexResponse> listener) {
        this.internalClient.index(request, listener);
    }

    @Override
    public ActionFuture<UpdateResponse> update(UpdateRequest request) {
        return this.internalClient.update(request);
    }

    @Override
    public void update(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        this.internalClient.update(request, listener);
    }

    @Override
    public ActionFuture<DeleteResponse> delete(DeleteRequest request) {
        return this.internalClient.delete(request);
    }

    @Override
    public void delete(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        this.internalClient.delete(request, listener);
    }

    @Override
    public ActionFuture<BulkResponse> bulk(BulkRequest request) {
        return this.internalClient.bulk(request);
    }

    @Override
    public void bulk(BulkRequest request, ActionListener<BulkResponse> listener) {
        this.internalClient.bulk(request, listener);
    }

    @Override
    public ActionFuture<DeleteByQueryResponse> deleteByQuery(DeleteByQueryRequest request) {
        return this.internalClient.deleteByQuery(request);
    }

    @Override
    public void deleteByQuery(DeleteByQueryRequest request, ActionListener<DeleteByQueryResponse> listener) {
        this.internalClient.deleteByQuery(request, listener);
    }

    @Override
    public ActionFuture<GetResponse> get(GetRequest request) {
        return this.internalClient.get(request);
    }

    @Override
    public void get(GetRequest request, ActionListener<GetResponse> listener) {
        this.internalClient.get(request, listener);
    }

    @Override
    public ActionFuture<MultiGetResponse> multiGet(MultiGetRequest request) {
        return this.internalClient.multiGet(request);
    }

    @Override
    public void multiGet(MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        this.internalClient.multiGet(request, listener);
    }

    @Override
    public ActionFuture<CountResponse> count(CountRequest request) {
        return this.internalClient.count(request);
    }

    @Override
    public void count(CountRequest request, ActionListener<CountResponse> listener) {
        this.internalClient.count(request, listener);
    }

    @Override
    public ActionFuture<SearchResponse> search(SearchRequest request) {
        return this.internalClient.search(request);
    }

    @Override
    public void search(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.internalClient.search(request, listener);
    }

    @Override
    public ActionFuture<SearchResponse> searchScroll(SearchScrollRequest request) {
        return this.internalClient.searchScroll(request);
    }

    @Override
    public void searchScroll(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        this.internalClient.searchScroll(request, listener);
    }

    @Override
    public ActionFuture<MultiSearchResponse> multiSearch(MultiSearchRequest request) {
        return this.internalClient.multiSearch(request);
    }

    @Override
    public void multiSearch(MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        this.internalClient.multiSearch(request, listener);
    }

    @Override
    public ActionFuture<SearchResponse> moreLikeThis(MoreLikeThisRequest request) {
        return this.internalClient.moreLikeThis(request);
    }

    @Override
    public void moreLikeThis(MoreLikeThisRequest request, ActionListener<SearchResponse> listener) {
        this.internalClient.moreLikeThis(request, listener);
    }

    @Override
    public ActionFuture<PercolateResponse> percolate(PercolateRequest request) {
        return this.internalClient.percolate(request);
    }

    @Override
    public void percolate(PercolateRequest request, ActionListener<PercolateResponse> listener) {
        this.internalClient.percolate(request, listener);
    }

    @Override
    public ActionFuture<ExplainResponse> explain(ExplainRequest request) {
        return this.internalClient.explain(request);
    }

    @Override
    public void explain(ExplainRequest request, ActionListener<ExplainResponse> listener) {
        this.internalClient.explain(request, listener);
    }
}

