/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class IndicesReplicationOperationRequest<T extends IndicesReplicationOperationRequest>
extends ActionRequest<T> {
    protected TimeValue timeout = ShardReplicationOperationRequest.DEFAULT_TIMEOUT;
    protected String[] indices;
    protected ReplicationType replicationType = ReplicationType.DEFAULT;
    protected WriteConsistencyLevel consistencyLevel = WriteConsistencyLevel.DEFAULT;

    public TimeValue timeout() {
        return this.timeout;
    }

    public final T timeout(TimeValue timeout2) {
        this.timeout = timeout2;
        return (T)this;
    }

    public T timeout(String timeout2) {
        this.timeout = TimeValue.parseTimeValue(timeout2, null);
        return (T)this;
    }

    public String[] indices() {
        return this.indices;
    }

    public final T indices(String[] indices2) {
        this.indices = indices2;
        return (T)this;
    }

    public ReplicationType replicationType() {
        return this.replicationType;
    }

    public final T replicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return (T)this;
    }

    public final T replicationType(String replicationType) {
        return this.replicationType(ReplicationType.fromString(replicationType));
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public final T consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return (T)this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.replicationType = ReplicationType.fromId(in.readByte());
        this.consistencyLevel = WriteConsistencyLevel.fromId(in.readByte());
        this.timeout = TimeValue.readTimeValue(in);
        this.indices = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.replicationType.id());
        out.writeByte(this.consistencyLevel.id());
        this.timeout.writeTo(out);
        out.writeStringArrayNullable(this.indices);
    }
}

