/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;

public class AutoCreateIndex {
    private final boolean needToCheck;
    private final boolean globallyDisabled;
    private final String[] matches;
    private final String[] matches2;

    public AutoCreateIndex(Settings settings) {
        String value2 = settings.get("action.auto_create_index");
        if (value2 == null || Booleans.isExplicitTrue(value2)) {
            this.needToCheck = true;
            this.globallyDisabled = false;
            this.matches = null;
            this.matches2 = null;
        } else if (Booleans.isExplicitFalse(value2)) {
            this.needToCheck = false;
            this.globallyDisabled = true;
            this.matches = null;
            this.matches2 = null;
        } else {
            this.needToCheck = true;
            this.globallyDisabled = false;
            this.matches = Strings.commaDelimitedListToStringArray(value2);
            this.matches2 = new String[this.matches.length];
            for (int i2 = 0; i2 < this.matches.length; ++i2) {
                this.matches2[i2] = this.matches[i2].substring(1);
            }
        }
    }

    public boolean needToCheck() {
        return this.needToCheck;
    }

    public boolean shouldAutoCreate(String index2, ClusterState state2) {
        if (!this.needToCheck) {
            return false;
        }
        if (state2.metaData().hasConcreteIndex(index2)) {
            return false;
        }
        if (this.globallyDisabled) {
            return false;
        }
        if (this.matches == null) {
            return true;
        }
        for (int i2 = 0; i2 < this.matches.length; ++i2) {
            char c = this.matches[i2].charAt(0);
            if (c == '-') {
                if (!Regex.simpleMatch(this.matches2[i2], index2)) continue;
                return false;
            }
            if (!(c == '+' ? Regex.simpleMatch(this.matches2[i2], index2) : Regex.simpleMatch(this.matches[i2], index2))) continue;
            return true;
        }
        return false;
    }
}

