/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class TransportMultiSearchAction
extends TransportAction<MultiSearchRequest, MultiSearchResponse> {
    private final ClusterService clusterService;
    private final TransportSearchAction searchAction;

    @Inject
    public TransportMultiSearchAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportSearchAction searchAction) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.searchAction = searchAction;
        transportService.registerHandler("msearch", new TransportHandler());
    }

    @Override
    protected void doExecute(MultiSearchRequest request, final ActionListener<MultiSearchResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        final MultiSearchResponse.Item[] responses = new MultiSearchResponse.Item[request.requests().size()];
        final AtomicInteger counter = new AtomicInteger(responses.length);
        for (int i2 = 0; i2 < responses.length; ++i2) {
            final int index2 = i2;
            this.searchAction.execute((ActionRequest)request.requests().get(i2), new ActionListener<SearchResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(SearchResponse searchResponse) {
                    MultiSearchResponse.Item[] itemArray = responses;
                    synchronized (responses) {
                        responses[index2] = new MultiSearchResponse.Item(searchResponse, null);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        if (counter.decrementAndGet() == 0) {
                            this.finishHim();
                        }
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Throwable e) {
                    MultiSearchResponse.Item[] itemArray = responses;
                    synchronized (responses) {
                        responses[index2] = new MultiSearchResponse.Item(null, ExceptionsHelper.detailedMessage(e));
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        if (counter.decrementAndGet() == 0) {
                            this.finishHim();
                        }
                        return;
                    }
                }

                private void finishHim() {
                    listener.onResponse(new MultiSearchResponse(responses));
                }
            });
        }
    }

    class TransportHandler
    extends BaseTransportRequestHandler<MultiSearchRequest> {
        TransportHandler() {
        }

        @Override
        public MultiSearchRequest newInstance() {
            return new MultiSearchRequest();
        }

        @Override
        public void messageReceived(final MultiSearchRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportMultiSearchAction.this.execute(request, new ActionListener<MultiSearchResponse>(){

                @Override
                public void onResponse(MultiSearchResponse response) {
                    try {
                        channel.sendResponse(response);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportMultiSearchAction.this.logger.warn("Failed to send error response for action [msearch] and request [" + request + "]", e1, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

