/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class PercolateRequest
extends SingleCustomOperationRequest<PercolateRequest> {
    private String index;
    private String type;
    private BytesReference source;
    private boolean sourceUnsafe;

    public PercolateRequest() {
    }

    public PercolateRequest(String index2, String type2) {
        this.index = index2;
        this.type = type2;
    }

    public PercolateRequest index(String index2) {
        this.index = index2;
        return this;
    }

    public PercolateRequest type(String type2) {
        this.type = type2;
        return this;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void beforeLocalFork() {
        if (this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
            this.sourceUnsafe = false;
        }
    }

    public BytesReference source() {
        return this.source;
    }

    @Required
    public PercolateRequest source(Map source2) throws ElasticSearchGenerationException {
        return this.source(source2, XContentType.SMILE);
    }

    @Required
    public PercolateRequest source(Map source2, XContentType contentType) throws ElasticSearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source2);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source2 + "]", e);
        }
    }

    @Required
    public PercolateRequest source(String source2) {
        this.source = new BytesArray(source2);
        this.sourceUnsafe = false;
        return this;
    }

    @Required
    public PercolateRequest source(XContentBuilder sourceBuilder) {
        this.source = sourceBuilder.bytes();
        this.sourceUnsafe = false;
        return this;
    }

    public PercolateRequest source(byte[] source2) {
        return this.source(source2, 0, source2.length);
    }

    @Required
    public PercolateRequest source(byte[] source2, int offset2, int length2) {
        return this.source(source2, offset2, length2, false);
    }

    @Required
    public PercolateRequest source(byte[] source2, int offset2, int length2, boolean unsafe) {
        return this.source(new BytesArray(source2, offset2, length2), unsafe);
    }

    @Required
    public PercolateRequest source(BytesReference source2, boolean unsafe) {
        this.source = source2;
        this.sourceUnsafe = unsafe;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.type = in.readString();
        this.sourceUnsafe = false;
        this.source = in.readBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeString(this.type);
        out.writeBytesReference(this.source);
    }
}

