/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.mlt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.TransportGetAction;
import org.elasticsearch.action.mlt.MoreLikeThisRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisFieldQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportMoreLikeThisAction
extends TransportAction<MoreLikeThisRequest, SearchResponse> {
    private final TransportSearchAction searchAction;
    private final TransportGetAction getAction;
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final TransportService transportService;

    @Inject
    public TransportMoreLikeThisAction(Settings settings, ThreadPool threadPool, TransportSearchAction searchAction, TransportGetAction getAction, ClusterService clusterService, IndicesService indicesService, TransportService transportService) {
        super(settings, threadPool);
        this.searchAction = searchAction;
        this.getAction = getAction;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.transportService = transportService;
        transportService.registerHandler("mlt", new TransportHandler());
    }

    @Override
    protected void doExecute(final MoreLikeThisRequest request, final ActionListener<SearchResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        final String concreteIndex = clusterState.metaData().concreteIndex(request.index());
        RoutingNode routingNode = clusterState.getRoutingNodes().nodesToShards().get(this.clusterService.localNode().getId());
        if (routingNode == null) {
            this.redirect(request, listener, clusterState);
            return;
        }
        boolean hasIndexLocally = false;
        for (MutableShardRouting shardRouting : routingNode.shards()) {
            if (!concreteIndex.equals(shardRouting.index())) continue;
            hasIndexLocally = true;
            break;
        }
        if (!hasIndexLocally) {
            this.redirect(request, listener, clusterState);
            return;
        }
        HashSet<String> getFields = Sets.newHashSet();
        if (request.fields() != null) {
            Collections.addAll(getFields, request.fields());
        }
        getFields.add("_source");
        GetRequest getRequest = (GetRequest)((GetRequest)Requests.getRequest(concreteIndex).fields(getFields.toArray(new String[getFields.size()])).type(request.type()).id(request.id()).routing(request.routing()).listenerThreaded(true)).operationThreaded(true);
        request.beforeLocalFork();
        this.getAction.execute(getRequest, new ActionListener<GetResponse>(){

            @Override
            public void onResponse(GetResponse getResponse) {
                String[] searchTypes;
                if (!getResponse.exists()) {
                    listener.onFailure(new ElasticSearchException("document missing"));
                    return;
                }
                BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
                try {
                    DocumentMapper docMapper = TransportMoreLikeThisAction.this.indicesService.indexServiceSafe(concreteIndex).mapperService().documentMapper(request.type());
                    if (docMapper == null) {
                        throw new ElasticSearchException("No DocumentMapper found for type [" + request.type() + "]");
                    }
                    HashSet<String> fields2 = Sets.newHashSet();
                    if (request.fields() != null) {
                        for (String field2 : request.fields()) {
                            FieldMappers fieldMappers = docMapper.mappers().smartName(field2);
                            if (fieldMappers != null) {
                                fields2.add(fieldMappers.mapper().names().indexName());
                                continue;
                            }
                            fields2.add(field2);
                        }
                    }
                    if (!fields2.isEmpty()) {
                        Iterator it = fields2.iterator();
                        while (it.hasNext()) {
                            String field3 = (String)it.next();
                            GetField getField = getResponse.field(field3);
                            if (getField == null) continue;
                            for (Object value2 : getField.values()) {
                                TransportMoreLikeThisAction.this.addMoreLikeThis(request, boolBuilder, getField.name(), value2.toString());
                            }
                            it.remove();
                        }
                        if (!fields2.isEmpty()) {
                            TransportMoreLikeThisAction.this.parseSource(getResponse, boolBuilder, docMapper, fields2, request);
                        }
                    } else {
                        TransportMoreLikeThisAction.this.parseSource(getResponse, boolBuilder, docMapper, fields2, request);
                    }
                    if (!boolBuilder.hasClauses()) {
                        listener.onFailure(new ElasticSearchException("No fields found to fetch the 'likeText' from"));
                        return;
                    }
                    Term uidTerm = docMapper.uidMapper().term(request.type(), request.id());
                    boolBuilder.mustNot(QueryBuilders.termQuery(uidTerm.field(), uidTerm.text()));
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    return;
                }
                String[] searchIndices = request.searchIndices();
                if (searchIndices == null) {
                    searchIndices = new String[]{request.index()};
                }
                if ((searchTypes = request.searchTypes()) == null) {
                    searchTypes = new String[]{request.type()};
                }
                int size2 = request.searchSize() != 0 ? request.searchSize() : 10;
                int from = request.searchFrom() != 0 ? request.searchFrom() : 0;
                SearchRequest searchRequest = (SearchRequest)Requests.searchRequest(searchIndices).types(searchTypes).searchType(request.searchType()).scroll(request.searchScroll()).extraSource(SearchSourceBuilder.searchSource().query(boolBuilder).from(from).size(size2)).listenerThreaded(request.listenerThreaded());
                if (request.searchSource() != null) {
                    searchRequest.source(request.searchSource(), request.searchSourceUnsafe());
                }
                TransportMoreLikeThisAction.this.searchAction.execute(searchRequest, new ActionListener<SearchResponse>(){

                    @Override
                    public void onResponse(SearchResponse response) {
                        listener.onResponse(response);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        listener.onFailure(e);
                    }
                });
            }

            @Override
            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        });
    }

    private void redirect(MoreLikeThisRequest request, final ActionListener<SearchResponse> listener, ClusterState clusterState) {
        ShardIterator shardIterator = this.clusterService.operationRouting().getShards(clusterState, request.index(), request.type(), request.id(), null, null);
        ShardRouting shardRouting = shardIterator.firstOrNull();
        if (shardRouting == null) {
            throw new ElasticSearchException("No shards for index " + request.index());
        }
        String nodeId = shardRouting.currentNodeId();
        DiscoveryNode discoveryNode = clusterState.nodes().get(nodeId);
        this.transportService.sendRequest(discoveryNode, "mlt", request, new TransportResponseHandler<SearchResponse>(){

            @Override
            public SearchResponse newInstance() {
                return new SearchResponse();
            }

            @Override
            public void handleResponse(SearchResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp2) {
                listener.onFailure(exp2);
            }

            @Override
            public String executor() {
                return "same";
            }
        });
    }

    private void parseSource(GetResponse getResponse, final BoolQueryBuilder boolBuilder, DocumentMapper docMapper, final Set<String> fields2, final MoreLikeThisRequest request) {
        if (getResponse.source() == null) {
            return;
        }
        docMapper.parse(SourceToParse.source(getResponse.sourceRef()).type(request.type()).id(request.id()), new DocumentMapper.ParseListenerAdapter(){

            @Override
            public boolean beforeFieldAdded(FieldMapper fieldMapper, Fieldable field2, Object parseContext) {
                if (fieldMapper instanceof InternalMapper) {
                    return true;
                }
                String value2 = fieldMapper.valueAsString(field2);
                if (value2 == null) {
                    return false;
                }
                if (fields2.isEmpty() || fields2.contains(field2.name())) {
                    TransportMoreLikeThisAction.this.addMoreLikeThis(request, boolBuilder, fieldMapper, field2);
                }
                return false;
            }
        });
    }

    private void addMoreLikeThis(MoreLikeThisRequest request, BoolQueryBuilder boolBuilder, FieldMapper fieldMapper, Fieldable field2) {
        this.addMoreLikeThis(request, boolBuilder, field2.name(), fieldMapper.valueAsString(field2));
    }

    private void addMoreLikeThis(MoreLikeThisRequest request, BoolQueryBuilder boolBuilder, String fieldName, String likeText) {
        MoreLikeThisFieldQueryBuilder mlt = QueryBuilders.moreLikeThisFieldQuery(fieldName).likeText(likeText).percentTermsToMatch(request.percentTermsToMatch()).boostTerms(request.boostTerms()).minDocFreq(request.minDocFreq()).maxDocFreq(request.maxDocFreq()).minWordLen(request.minWordLen()).maxWordLen(request.maxWordLen()).minTermFreq(request.minTermFreq()).maxQueryTerms(request.maxQueryTerms()).stopWords(request.stopWords());
        boolBuilder.should(mlt);
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<MoreLikeThisRequest> {
        private TransportHandler() {
        }

        @Override
        public MoreLikeThisRequest newInstance() {
            return new MoreLikeThisRequest();
        }

        @Override
        public void messageReceived(MoreLikeThisRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportMoreLikeThisAction.this.execute(request, new ActionListener<SearchResponse>(){

                @Override
                public void onResponse(SearchResponse result2) {
                    try {
                        channel.sendResponse(result2);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportMoreLikeThisAction.this.logger.warn("Failed to send response for get", e1, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

