/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndexDeleteByQueryResponse
extends ActionResponse {
    private String index;
    private int successfulShards;
    private int failedShards;

    IndexDeleteByQueryResponse(String index2, int successfulShards, int failedShards) {
        this.index = index2;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
    }

    IndexDeleteByQueryResponse() {
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index;
    }

    public int totalShards() {
        return this.failedShards + this.successfulShards;
    }

    public int getTotalShards() {
        return this.totalShards();
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int failedShards() {
        return this.failedShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
    }
}

