/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.replication.IndicesReplicationOperationRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;

public class DeleteByQueryRequest
extends IndicesReplicationOperationRequest<DeleteByQueryRequest> {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    private BytesReference querySource;
    private boolean querySourceUnsafe;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private String routing;

    public DeleteByQueryRequest(String ... indices2) {
        this.indices = indices2;
    }

    public DeleteByQueryRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.querySource == null) {
            validationException = ValidateActions.addValidationError("query is missing", validationException);
        }
        return validationException;
    }

    BytesReference querySource() {
        if (this.querySourceUnsafe) {
            this.querySource = this.querySource.copyBytesArray();
        }
        return this.querySource;
    }

    @Required
    public DeleteByQueryRequest query(QueryBuilder queryBuilder) {
        this.querySource = queryBuilder.buildAsBytes();
        this.querySourceUnsafe = false;
        return this;
    }

    @Required
    public DeleteByQueryRequest query(String querySource) {
        this.querySource = new BytesArray(querySource.getBytes(Charsets.UTF_8));
        this.querySourceUnsafe = false;
        return this;
    }

    @Required
    public DeleteByQueryRequest query(Map querySource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(querySource);
            return this.query(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + querySource + "]", e);
        }
    }

    @Required
    public DeleteByQueryRequest query(XContentBuilder builder) {
        this.querySource = builder.bytes();
        this.querySourceUnsafe = false;
        return this;
    }

    @Required
    public DeleteByQueryRequest query(byte[] querySource) {
        return this.query(querySource, 0, querySource.length, false);
    }

    @Required
    public DeleteByQueryRequest query(byte[] querySource, int offset2, int length2, boolean unsafe) {
        this.querySource = new BytesArray(querySource, offset2, length2);
        this.querySourceUnsafe = unsafe;
        return this;
    }

    public DeleteByQueryRequest query(BytesReference source2, boolean unsafe) {
        this.querySource = source2;
        this.querySourceUnsafe = unsafe;
        return this;
    }

    String[] types() {
        return this.types;
    }

    public String routing() {
        return this.routing;
    }

    public DeleteByQueryRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public DeleteByQueryRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public DeleteByQueryRequest types(String ... types) {
        this.types = types;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.querySourceUnsafe = false;
        this.querySource = in.readBytesReference();
        this.routing = in.readOptionalString();
        this.types = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.querySource);
        out.writeOptionalString(this.routing);
        out.writeStringArray(this.types);
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.querySource, false);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return "[" + Arrays.toString(this.indices) + "][" + Arrays.toString(this.types) + "], querySource[" + sSource + "]";
    }
}

