/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.warmer.put;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class PutWarmerRequest
extends MasterNodeOperationRequest<PutWarmerRequest> {
    private String name;
    private SearchRequest searchRequest;

    PutWarmerRequest() {
    }

    public PutWarmerRequest(String name2) {
        this.name = name2;
    }

    public PutWarmerRequest name(String name2) {
        this.name = name2;
        return this;
    }

    String name() {
        return this.name;
    }

    public PutWarmerRequest searchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        return this;
    }

    public PutWarmerRequest searchRequest(SearchRequestBuilder searchRequest) {
        this.searchRequest = searchRequest.request();
        return this;
    }

    @Nullable
    SearchRequest searchRequest() {
        return this.searchRequest;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = this.searchRequest.validate();
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.name = in.readString();
        if (in.readBoolean()) {
            this.searchRequest = new SearchRequest();
            this.searchRequest.readFrom(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        if (this.searchRequest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.searchRequest.writeTo(out);
        }
    }
}

