/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class PutIndexTemplateRequest
extends MasterNodeOperationRequest<PutIndexTemplateRequest> {
    private String name;
    private String cause = "";
    private String template;
    private int order;
    private boolean create;
    private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
    private Map<String, String> mappings = Maps.newHashMap();
    private Map<String, IndexMetaData.Custom> customs = Maps.newHashMap();
    private TimeValue timeout = new TimeValue(10L, TimeUnit.SECONDS);

    PutIndexTemplateRequest() {
    }

    public PutIndexTemplateRequest(String name2) {
        this.name = name2;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.template == null) {
            validationException = ValidateActions.addValidationError("template is missing", validationException);
        }
        return validationException;
    }

    public PutIndexTemplateRequest name(String name2) {
        this.name = name2;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutIndexTemplateRequest template(String template) {
        this.template = template;
        return this;
    }

    public String template() {
        return this.template;
    }

    public PutIndexTemplateRequest order(int order2) {
        this.order = order2;
        return this;
    }

    public int order() {
        return this.order;
    }

    public PutIndexTemplateRequest create(boolean create2) {
        this.create = create2;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public PutIndexTemplateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutIndexTemplateRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public PutIndexTemplateRequest settings(String source2) {
        this.settings = ImmutableSettings.settingsBuilder().loadFromSource(source2).build();
        return this;
    }

    public PutIndexTemplateRequest settings(Map<String, Object> source2) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source2);
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source2 + "]", e);
        }
        return this;
    }

    Settings settings() {
        return this.settings;
    }

    public PutIndexTemplateRequest mapping(String type2, String source2) {
        this.mappings.put(type2, source2);
        return this;
    }

    public PutIndexTemplateRequest cause(String cause2) {
        this.cause = cause2;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public PutIndexTemplateRequest mapping(String type2, XContentBuilder source2) {
        try {
            this.mappings.put(type2, source2.string());
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to build json for mapping request", e);
        }
        return this;
    }

    public PutIndexTemplateRequest mapping(String type2, Map<String, Object> source2) {
        if (source2.size() != 1 || !source2.containsKey(type2)) {
            source2 = MapBuilder.newMapBuilder().put(type2, source2).map();
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source2);
            return this.mapping(type2, builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source2 + "]", e);
        }
    }

    Map<String, String> mappings() {
        return this.mappings;
    }

    public PutIndexTemplateRequest source(XContentBuilder templateBuilder) {
        try {
            return this.source(templateBuilder.bytes());
        }
        catch (Exception e) {
            throw new ElasticSearchIllegalArgumentException("Failed to build json for template request", e);
        }
    }

    public PutIndexTemplateRequest source(Map templateSource) {
        Map source2 = templateSource;
        for (Map.Entry entry : source2.entrySet()) {
            String name2 = (String)entry.getKey();
            if (name2.equals("template")) {
                this.template(entry.getValue().toString());
                continue;
            }
            if (name2.equals("order")) {
                this.order(XContentMapValues.nodeIntegerValue(entry.getValue(), this.order()));
                continue;
            }
            if (name2.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new ElasticSearchIllegalArgumentException("Malformed settings section, should include an inner object");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name2.equals("mappings")) {
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    if (!(entry1.getValue() instanceof Map)) {
                        throw new ElasticSearchIllegalArgumentException("Malformed mappings section for type [" + (String)entry1.getKey() + "], should include an inner object describing the mapping");
                    }
                    this.mapping((String)entry1.getKey(), (Map)entry1.getValue());
                }
                continue;
            }
            IndexMetaData.Custom.Factory factory = IndexMetaData.lookupFactory(name2);
            if (factory == null) continue;
            try {
                this.customs.put(name2, (IndexMetaData.Custom)factory.fromMap((Map)entry.getValue()));
            }
            catch (IOException e) {
                throw new ElasticSearchParseException("failed to parse custom metadata for [" + name2 + "]");
            }
        }
        return this;
    }

    public PutIndexTemplateRequest source(String templateSource) {
        try {
            return this.source(XContentFactory.xContent(templateSource).createParser(templateSource).mapOrderedAndClose());
        }
        catch (Exception e) {
            throw new ElasticSearchIllegalArgumentException("failed to parse template source [" + templateSource + "]", e);
        }
    }

    public PutIndexTemplateRequest source(byte[] source2) {
        return this.source(source2, 0, source2.length);
    }

    public PutIndexTemplateRequest source(byte[] source2, int offset2, int length2) {
        try {
            return this.source(XContentFactory.xContent(source2, offset2, length2).createParser(source2, offset2, length2).mapOrderedAndClose());
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("failed to parse template source", e);
        }
    }

    public PutIndexTemplateRequest source(BytesReference source2) {
        try {
            return this.source(XContentFactory.xContent(source2).createParser(source2).mapOrderedAndClose());
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("failed to parse template source", e);
        }
    }

    public PutIndexTemplateRequest custom(IndexMetaData.Custom custom) {
        this.customs.put(custom.type(), custom);
        return this;
    }

    Map<String, IndexMetaData.Custom> customs() {
        return this.customs;
    }

    TimeValue timeout() {
        return this.timeout;
    }

    public PutIndexTemplateRequest timeout(TimeValue timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public PutIndexTemplateRequest timeout(String timeout2) {
        return this.timeout(TimeValue.parseTimeValue(timeout2, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.cause = in.readString();
        this.name = in.readString();
        this.template = in.readString();
        this.order = in.readInt();
        this.create = in.readBoolean();
        this.settings = ImmutableSettings.readSettingsFromStream(in);
        this.timeout = TimeValue.readTimeValue(in);
        int size2 = in.readVInt();
        for (int i2 = 0; i2 < size2; ++i2) {
            this.mappings.put(in.readString(), in.readString());
        }
        int customSize = in.readVInt();
        for (int i3 = 0; i3 < customSize; ++i3) {
            String type2 = in.readString();
            Object customIndexMetaData = IndexMetaData.lookupFactorySafe(type2).readFrom(in);
            this.customs.put(type2, (IndexMetaData.Custom)customIndexMetaData);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.name);
        out.writeString(this.template);
        out.writeInt(this.order);
        out.writeBoolean(this.create);
        ImmutableSettings.writeSettingsToStream(this.settings, out);
        this.timeout.writeTo(out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeVInt(this.customs.size());
        for (Map.Entry<String, Object> entry : this.customs.entrySet()) {
            out.writeString(entry.getKey());
            IndexMetaData.lookupFactorySafe(entry.getKey()).writeTo((IndexMetaData.Custom)entry.getValue(), out);
        }
    }
}

