/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public class GatewaySnapshotStatus {
    final Stage stage;
    final long startTime;
    final long time;
    final long indexSize;
    final int expectedNumberOfOperations;

    public GatewaySnapshotStatus(Stage stage, long startTime, long time, long indexSize, int expectedNumberOfOperations) {
        this.stage = stage;
        this.startTime = startTime;
        this.time = time;
        this.indexSize = indexSize;
        this.expectedNumberOfOperations = expectedNumberOfOperations;
    }

    public Stage stage() {
        return this.stage;
    }

    public Stage getStage() {
        return this.stage();
    }

    public long startTime() {
        return this.startTime;
    }

    public long getStartTime() {
        return this.startTime();
    }

    public TimeValue time() {
        return TimeValue.timeValueMillis(this.time);
    }

    public TimeValue getTime() {
        return this.time();
    }

    public ByteSizeValue indexSize() {
        return new ByteSizeValue(this.indexSize);
    }

    public ByteSizeValue getIndexSize() {
        return this.indexSize();
    }

    public int expectedNumberOfOperations() {
        return this.expectedNumberOfOperations;
    }

    public int getExpectedNumberOfOperations() {
        return this.expectedNumberOfOperations();
    }

    public static enum Stage {
        NONE(0),
        INDEX(1),
        TRANSLOG(2),
        FINALIZE(3),
        DONE(4),
        FAILURE(5);

        private final byte value;

        private Stage(byte value2) {
            this.value = value2;
        }

        public byte value() {
            return this.value;
        }

        public static Stage fromValue(byte value2) {
            if (value2 == 0) {
                return NONE;
            }
            if (value2 == 1) {
                return INDEX;
            }
            if (value2 == 2) {
                return TRANSLOG;
            }
            if (value2 == 3) {
                return FINALIZE;
            }
            if (value2 == 4) {
                return DONE;
            }
            if (value2 == 5) {
                return FAILURE;
            }
            throw new ElasticSearchIllegalArgumentException("No stage found for [" + value2 + "]");
        }
    }
}

