/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.flush;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class ShardFlushRequest
extends BroadcastShardOperationRequest {
    private boolean refresh;
    private boolean full;
    private boolean force;

    ShardFlushRequest() {
    }

    public ShardFlushRequest(String index2, int shardId, FlushRequest request) {
        super(index2, shardId, request);
        this.refresh = request.refresh();
        this.full = request.full();
        this.force = request.force();
    }

    public boolean refresh() {
        return this.refresh;
    }

    public boolean full() {
        return this.full;
    }

    public boolean force() {
        return this.force;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.refresh = in.readBoolean();
        this.full = in.readBoolean();
        this.force = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.refresh);
        out.writeBoolean(this.full);
        out.writeBoolean(this.force);
    }
}

