/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.bson.util.Assertions;
import org.bson.util.CopyOnWriteMap;
import org.bson.util.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComputingMap<K, V>
implements Map<K, V>,
Function<K, V> {
    private final ConcurrentMap<K, V> map;
    private final Function<K, V> function;

    public static <K, V> Map<K, V> create(Function<K, V> function) {
        return new ComputingMap(CopyOnWriteMap.newHashMap(), function);
    }

    ComputingMap(ConcurrentMap<K, V> map, Function<K, V> function) {
        this.map = Assertions.notNull("map", map);
        this.function = Assertions.notNull("function", function);
    }

    @Override
    public V get(Object key2) {
        Object v;
        while ((v = this.map.get(key2)) == null) {
            Object k = key2;
            V value2 = this.function.apply(k);
            if (value2 == null) {
                return null;
            }
            this.map.putIfAbsent(k, value2);
        }
        return v;
    }

    @Override
    public V apply(K k) {
        return this.get(k);
    }

    @Override
    public V putIfAbsent(K key2, V value2) {
        return this.map.putIfAbsent(key2, value2);
    }

    @Override
    public boolean remove(Object key2, Object value2) {
        return this.map.remove(key2, value2);
    }

    @Override
    public boolean replace(K key2, V oldValue, V newValue) {
        return this.map.replace(key2, oldValue, newValue);
    }

    @Override
    public V replace(K key2, V value2) {
        return this.map.replace(key2, value2);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.map.containsValue(value2);
    }

    @Override
    public V put(K key2, V value2) {
        return this.map.put(key2, value2);
    }

    @Override
    public V remove(Object key2) {
        return this.map.remove(key2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

