/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Bits {
    public static void readFully(InputStream in, byte[] b) throws IOException {
        Bits.readFully(in, b, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int length2) throws IOException {
        Bits.readFully(in, b, 0, length2);
    }

    public static void readFully(InputStream in, byte[] b, int startOffset, int length2) throws IOException {
        if (b.length - startOffset > length2) {
            throw new IllegalArgumentException("Buffer is too small");
        }
        int offset2 = startOffset;
        int toRead = length2;
        while (toRead > 0) {
            int bytesRead = in.read(b, offset2, toRead);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            toRead -= bytesRead;
            offset2 += bytesRead;
        }
    }

    public static int readInt(InputStream in) throws IOException {
        return Bits.readInt(in, new byte[4]);
    }

    public static int readInt(InputStream in, byte[] data2) throws IOException {
        Bits.readFully(in, data2, 4);
        return Bits.readInt(data2);
    }

    public static int readInt(byte[] data2) {
        return Bits.readInt(data2, 0);
    }

    public static int readInt(byte[] data2, int offset2) {
        int x = 0;
        x |= (0xFF & data2[offset2 + 0]) << 0;
        x |= (0xFF & data2[offset2 + 1]) << 8;
        x |= (0xFF & data2[offset2 + 2]) << 16;
        return x |= (0xFF & data2[offset2 + 3]) << 24;
    }

    public static int readIntBE(byte[] data2, int offset2) {
        int x = 0;
        x |= (0xFF & data2[offset2 + 0]) << 24;
        x |= (0xFF & data2[offset2 + 1]) << 16;
        x |= (0xFF & data2[offset2 + 2]) << 8;
        return x |= (0xFF & data2[offset2 + 3]) << 0;
    }

    public static long readLong(InputStream in) throws IOException {
        return Bits.readLong(in, new byte[8]);
    }

    public static long readLong(InputStream in, byte[] data2) throws IOException {
        Bits.readFully(in, data2, 8);
        return Bits.readLong(data2);
    }

    public static long readLong(byte[] data2) {
        return Bits.readLong(data2, 0);
    }

    public static long readLong(byte[] data2, int offset2) {
        long x = 0L;
        x |= (0xFFL & (long)data2[offset2 + 0]) << 0;
        x |= (0xFFL & (long)data2[offset2 + 1]) << 8;
        x |= (0xFFL & (long)data2[offset2 + 2]) << 16;
        x |= (0xFFL & (long)data2[offset2 + 3]) << 24;
        x |= (0xFFL & (long)data2[offset2 + 4]) << 32;
        x |= (0xFFL & (long)data2[offset2 + 5]) << 40;
        x |= (0xFFL & (long)data2[offset2 + 6]) << 48;
        return x |= (0xFFL & (long)data2[offset2 + 7]) << 56;
    }
}

