/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.PackedInts;

public class GrowableWriter
implements PackedInts.Mutable {
    private long currentMaxValue;
    private PackedInts.Mutable current;
    private final boolean roundFixedSize;

    public GrowableWriter(int startBitsPerValue, int valueCount, boolean roundFixedSize) {
        this.roundFixedSize = roundFixedSize;
        this.current = PackedInts.getMutable(valueCount, this.getSize(startBitsPerValue));
        this.currentMaxValue = PackedInts.maxValue(this.current.getBitsPerValue());
    }

    private final int getSize(int bpv) {
        if (this.roundFixedSize) {
            return PackedInts.getNextFixedSize(bpv);
        }
        return bpv;
    }

    public long get(int index2) {
        return this.current.get(index2);
    }

    public int size() {
        return this.current.size();
    }

    public int getBitsPerValue() {
        return this.current.getBitsPerValue();
    }

    public PackedInts.Mutable getMutable() {
        return this.current;
    }

    public Object getArray() {
        return this.current.getArray();
    }

    public boolean hasArray() {
        return this.current.hasArray();
    }

    public void set(int index2, long value2) {
        if (value2 >= this.currentMaxValue) {
            int bpv = this.getBitsPerValue();
            while (this.currentMaxValue <= value2 && this.currentMaxValue != Long.MAX_VALUE) {
                ++bpv;
                this.currentMaxValue *= 2L;
            }
            int valueCount = this.size();
            PackedInts.Mutable next = PackedInts.getMutable(valueCount, this.getSize(bpv));
            for (int i2 = 0; i2 < valueCount; ++i2) {
                next.set(i2, this.current.get(i2));
            }
            this.current = next;
            this.currentMaxValue = PackedInts.maxValue(this.current.getBitsPerValue());
        }
        this.current.set(index2, value2);
    }

    public void clear() {
        this.current.clear();
    }

    public GrowableWriter resize(int newSize) {
        GrowableWriter next = new GrowableWriter(this.getBitsPerValue(), newSize, this.roundFixedSize);
        int limit2 = Math.min(this.size(), newSize);
        for (int i2 = 0; i2 < limit2; ++i2) {
            next.set(i2, this.get(i2));
        }
        return next;
    }
}

