/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Direct8
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    private byte[] values;
    private static final int BITS_PER_VALUE = 8;

    public Direct8(int valueCount) {
        super(valueCount, 8);
        this.values = new byte[valueCount];
    }

    public Direct8(DataInput in, int valueCount) throws IOException {
        super(valueCount, 8);
        byte[] values2 = new byte[valueCount];
        for (int i2 = 0; i2 < valueCount; ++i2) {
            values2[i2] = in.readByte();
        }
        int mod = valueCount % 8;
        if (mod != 0) {
            int pad = 8 - mod;
            for (int i3 = 0; i3 < pad; ++i3) {
                in.readByte();
            }
        }
        this.values = values2;
    }

    public Direct8(byte[] values2) {
        super(values2.length, 8);
        this.values = values2;
    }

    public long get(int index2) {
        assert (index2 >= 0 && index2 < this.size());
        return 0xFFL & (long)this.values[index2];
    }

    public void set(int index2, long value2) {
        this.values[index2] = (byte)(value2 & 0xFFL);
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this.values);
    }

    public void clear() {
        Arrays.fill(this.values, (byte)0);
    }

    public Object getArray() {
        return this.values;
    }

    public boolean hasArray() {
        return true;
    }
}

