/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Direct16
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    private short[] values;
    private static final int BITS_PER_VALUE = 16;

    public Direct16(int valueCount) {
        super(valueCount, 16);
        this.values = new short[valueCount];
    }

    public Direct16(DataInput in, int valueCount) throws IOException {
        super(valueCount, 16);
        short[] values2 = new short[valueCount];
        for (int i2 = 0; i2 < valueCount; ++i2) {
            values2[i2] = in.readShort();
        }
        int mod = valueCount % 4;
        if (mod != 0) {
            int pad = 4 - mod;
            for (int i3 = 0; i3 < pad; ++i3) {
                in.readShort();
            }
        }
        this.values = values2;
    }

    public Direct16(short[] values2) {
        super(values2.length, 16);
        this.values = values2;
    }

    public long get(int index2) {
        assert (index2 >= 0 && index2 < this.size());
        return 0xFFFFL & (long)this.values[index2];
    }

    public void set(int index2, long value2) {
        this.values[index2] = (short)(value2 & 0xFFFFL);
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this.values);
    }

    public void clear() {
        Arrays.fill(this.values, (short)0);
    }

    public Object getArray() {
        return this.values;
    }

    public boolean hasArray() {
        return true;
    }
}

