/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;

public final class UnicodeUtil {
    public static final int UNI_SUR_HIGH_START = 55296;
    public static final int UNI_SUR_HIGH_END = 56319;
    public static final int UNI_SUR_LOW_START = 56320;
    public static final int UNI_SUR_LOW_END = 57343;
    public static final int UNI_REPLACEMENT_CHAR = 65533;
    private static final long UNI_MAX_BMP = 65535L;
    private static final int HALF_BASE = 65536;
    private static final long HALF_SHIFT = 10L;
    private static final long HALF_MASK = 1023L;
    private static final int SURROGATE_OFFSET = -56613888;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int TRAIL_SURROGATE_MASK_ = 1023;
    private static final int TRAIL_SURROGATE_MIN_VALUE = 56320;
    private static final int LEAD_SURROGATE_MIN_VALUE = 55296;
    private static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    private static final int LEAD_SURROGATE_OFFSET_ = 55232;

    private UnicodeUtil() {
    }

    public static int UTF16toUTF8WithHash(char[] source2, int offset2, int length2, BytesRef result2) {
        int hash2 = 0;
        int upto2 = 0;
        int i2 = offset2;
        int end2 = offset2 + length2;
        byte[] out = result2.bytes;
        int maxLen = length2 * 4;
        if (out.length < maxLen) {
            out = result2.bytes = new byte[ArrayUtil.oversize(maxLen, 1)];
        }
        result2.offset = 0;
        while (i2 < end2) {
            int utf32;
            char code;
            if ((code = source2[i2++]) < '\u0080') {
                int n = upto2++;
                byte by = (byte)code;
                out[n] = by;
                hash2 = 31 * hash2 + by;
                continue;
            }
            if (code < '\u0800') {
                int n = upto2++;
                byte by = (byte)(0xC0 | code >> 6);
                out[n] = by;
                hash2 = 31 * hash2 + by;
                int n2 = upto2++;
                byte by2 = (byte)(0x80 | code & 0x3F);
                out[n2] = by2;
                hash2 = 31 * hash2 + by2;
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                int n = upto2++;
                byte by = (byte)(0xE0 | code >> 12);
                out[n] = by;
                hash2 = 31 * hash2 + by;
                int n3 = upto2++;
                byte by3 = (byte)(0x80 | code >> 6 & 0x3F);
                out[n3] = by3;
                hash2 = 31 * hash2 + by3;
                int n4 = upto2++;
                byte by4 = (byte)(0x80 | code & 0x3F);
                out[n4] = by4;
                hash2 = 31 * hash2 + by4;
                continue;
            }
            if (code < '\udc00' && i2 < end2 && (utf32 = source2[i2]) >= 56320 && utf32 <= 57343) {
                utf32 = (code << 10) + utf32 + -56613888;
                ++i2;
                int n = upto2++;
                byte by = (byte)(0xF0 | utf32 >> 18);
                out[n] = by;
                hash2 = 31 * hash2 + by;
                int n5 = upto2++;
                byte by5 = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[n5] = by5;
                hash2 = 31 * hash2 + by5;
                int n6 = upto2++;
                byte by6 = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[n6] = by6;
                hash2 = 31 * hash2 + by6;
                int n7 = upto2++;
                byte by7 = (byte)(0x80 | utf32 & 0x3F);
                out[n7] = by7;
                hash2 = 31 * hash2 + by7;
                continue;
            }
            out[upto2++] = -17;
            hash2 = 31 * hash2 + -17;
            out[upto2++] = -65;
            hash2 = 31 * hash2 + -65;
            out[upto2++] = -67;
            hash2 = 31 * hash2 + -67;
        }
        result2.length = upto2;
        return hash2;
    }

    public static void UTF16toUTF8(char[] source2, int offset2, UTF8Result result2) {
        int upto2 = 0;
        int i2 = offset2;
        byte[] out = result2.result;
        while (true) {
            int utf32;
            char code = source2[i2++];
            if (upto2 + 4 > out.length) {
                out = result2.result = ArrayUtil.grow(out, upto2 + 4);
            }
            if (code < '\u0080') {
                out[upto2++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto2++] = (byte)(0xC0 | code >> 6);
                out[upto2++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                if (code == '\uffff') break;
                out[upto2++] = (byte)(0xE0 | code >> 12);
                out[upto2++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto2++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && source2[i2] != '\uffff' && (utf32 = source2[i2]) >= 56320 && utf32 <= 57343) {
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                ++i2;
                out[upto2++] = (byte)(0xF0 | utf32 >> 18);
                out[upto2++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto2++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto2++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto2++] = -17;
            out[upto2++] = -65;
            out[upto2++] = -67;
        }
        result2.length = upto2;
    }

    public static void UTF16toUTF8(char[] source2, int offset2, int length2, UTF8Result result2) {
        int upto2 = 0;
        int i2 = offset2;
        int end2 = offset2 + length2;
        byte[] out = result2.result;
        while (i2 < end2) {
            int utf32;
            char code = source2[i2++];
            if (upto2 + 4 > out.length) {
                out = result2.result = ArrayUtil.grow(out, upto2 + 4);
            }
            if (code < '\u0080') {
                out[upto2++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto2++] = (byte)(0xC0 | code >> 6);
                out[upto2++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto2++] = (byte)(0xE0 | code >> 12);
                out[upto2++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto2++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i2 < end2 && source2[i2] != '\uffff' && (utf32 = source2[i2]) >= 56320 && utf32 <= 57343) {
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                ++i2;
                out[upto2++] = (byte)(0xF0 | utf32 >> 18);
                out[upto2++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto2++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto2++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto2++] = -17;
            out[upto2++] = -65;
            out[upto2++] = -67;
        }
        result2.length = upto2;
    }

    public static void UTF16toUTF8(String s2, int offset2, int length2, UTF8Result result2) {
        int end2 = offset2 + length2;
        byte[] out = result2.result;
        int upto2 = 0;
        for (int i2 = offset2; i2 < end2; ++i2) {
            int utf32;
            char code = s2.charAt(i2);
            if (upto2 + 4 > out.length) {
                out = result2.result = ArrayUtil.grow(out, upto2 + 4);
            }
            if (code < '\u0080') {
                out[upto2++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto2++] = (byte)(0xC0 | code >> 6);
                out[upto2++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto2++] = (byte)(0xE0 | code >> 12);
                out[upto2++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto2++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i2 < end2 - 1 && (utf32 = s2.charAt(i2 + 1)) >= 56320 && utf32 <= 57343) {
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                ++i2;
                out[upto2++] = (byte)(0xF0 | utf32 >> 18);
                out[upto2++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto2++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto2++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto2++] = -17;
            out[upto2++] = -65;
            out[upto2++] = -67;
        }
        result2.length = upto2;
    }

    public static void UTF16toUTF8(CharSequence s2, int offset2, int length2, BytesRef result2) {
        int end2 = offset2 + length2;
        byte[] out = result2.bytes;
        result2.offset = 0;
        int maxLen = length2 * 4;
        if (out.length < maxLen) {
            out = result2.bytes = new byte[maxLen];
        }
        int upto2 = 0;
        for (int i2 = offset2; i2 < end2; ++i2) {
            int utf32;
            char code = s2.charAt(i2);
            if (code < '\u0080') {
                out[upto2++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto2++] = (byte)(0xC0 | code >> 6);
                out[upto2++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto2++] = (byte)(0xE0 | code >> 12);
                out[upto2++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto2++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i2 < end2 - 1 && (utf32 = s2.charAt(i2 + 1)) >= 56320 && utf32 <= 57343) {
                utf32 = (code << 10) + utf32 + -56613888;
                ++i2;
                out[upto2++] = (byte)(0xF0 | utf32 >> 18);
                out[upto2++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto2++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto2++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto2++] = -17;
            out[upto2++] = -65;
            out[upto2++] = -67;
        }
        result2.length = upto2;
    }

    public static void UTF16toUTF8(char[] source2, int offset2, int length2, BytesRef result2) {
        int upto2 = 0;
        int i2 = offset2;
        int end2 = offset2 + length2;
        byte[] out = result2.bytes;
        int maxLen = length2 * 4;
        if (out.length < maxLen) {
            out = result2.bytes = new byte[maxLen];
        }
        result2.offset = 0;
        while (i2 < end2) {
            int utf32;
            char code;
            if ((code = source2[i2++]) < '\u0080') {
                out[upto2++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto2++] = (byte)(0xC0 | code >> 6);
                out[upto2++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto2++] = (byte)(0xE0 | code >> 12);
                out[upto2++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto2++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i2 < end2 && (utf32 = source2[i2]) >= 56320 && utf32 <= 57343) {
                utf32 = (code << 10) + utf32 + -56613888;
                ++i2;
                out[upto2++] = (byte)(0xF0 | utf32 >> 18);
                out[upto2++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto2++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto2++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto2++] = -17;
            out[upto2++] = -65;
            out[upto2++] = -67;
        }
        result2.length = upto2;
    }

    public static void UTF8toUTF16(byte[] utf8, int offset2, int length2, UTF16Result result2) {
        int end2 = offset2 + length2;
        char[] out = result2.result;
        if (result2.offsets.length <= end2) {
            result2.offsets = ArrayUtil.grow(result2.offsets, end2 + 1);
        }
        int[] offsets2 = result2.offsets;
        int upto2 = offset2;
        while (offsets2[upto2] == -1) {
            --upto2;
        }
        int outUpto = offsets2[upto2];
        if (outUpto + length2 >= out.length) {
            out = result2.result = ArrayUtil.grow(out, outUpto + length2 + 1);
        }
        while (upto2 < end2) {
            int ch;
            int b = utf8[upto2] & 0xFF;
            offsets2[upto2++] = outUpto;
            if (b < 192) {
                assert (b < 128);
                ch = b;
            } else if (b < 224) {
                ch = ((b & 0x1F) << 6) + (utf8[upto2] & 0x3F);
                offsets2[upto2++] = -1;
            } else if (b < 240) {
                ch = ((b & 0xF) << 12) + ((utf8[upto2] & 0x3F) << 6) + (utf8[upto2 + 1] & 0x3F);
                offsets2[upto2++] = -1;
                offsets2[upto2++] = -1;
            } else {
                assert (b < 248);
                ch = ((b & 7) << 18) + ((utf8[upto2] & 0x3F) << 12) + ((utf8[upto2 + 1] & 0x3F) << 6) + (utf8[upto2 + 2] & 0x3F);
                offsets2[upto2++] = -1;
                offsets2[upto2++] = -1;
                offsets2[upto2++] = -1;
            }
            if ((long)ch <= 65535L) {
                out[outUpto++] = (char)ch;
                continue;
            }
            int chHalf = ch - 65536;
            out[outUpto++] = (char)((chHalf >> 10) + 55296);
            out[outUpto++] = (char)(((long)chHalf & 0x3FFL) + 56320L);
        }
        offsets2[upto2] = outUpto;
        result2.length = outUpto;
    }

    public static String newString(int[] codePoints, int offset2, int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException();
        }
        char[] chars2 = new char[count2];
        int w = 0;
        int e = offset2 + count2;
        block2: for (int r = offset2; r < e; ++r) {
            int cp = codePoints[r];
            if (cp < 0 || cp > 0x10FFFF) {
                throw new IllegalArgumentException();
            }
            while (true) {
                try {
                    if (cp < 65536) {
                        chars2[w] = (char)cp;
                        ++w;
                        continue block2;
                    }
                    chars2[w] = (char)(55232 + (cp >> 10));
                    chars2[w + 1] = (char)(56320 + (cp & 0x3FF));
                    w += 2;
                    continue block2;
                }
                catch (IndexOutOfBoundsException ex) {
                    int newlen = (int)Math.ceil((double)codePoints.length * (double)(w + 2) / (double)(r - offset2 + 1));
                    char[] temp = new char[newlen];
                    System.arraycopy(chars2, 0, temp, 0, w);
                    chars2 = temp;
                    continue;
                }
                break;
            }
        }
        return new String(chars2, 0, w);
    }

    public static void UTF8toUTF16(byte[] utf8, int offset2, int length2, CharsRef chars2) {
        chars2.offset = 0;
        int out_offset = 0;
        chars2.chars = ArrayUtil.grow(chars2.chars, length2);
        char[] out = chars2.chars;
        int limit2 = offset2 + length2;
        while (offset2 < limit2) {
            int b;
            if ((b = utf8[offset2++] & 0xFF) < 192) {
                assert (b < 128);
                out[out_offset++] = (char)b;
                continue;
            }
            if (b < 224) {
                out[out_offset++] = (char)(((b & 0x1F) << 6) + (utf8[offset2++] & 0x3F));
                continue;
            }
            if (b < 240) {
                out[out_offset++] = (char)(((b & 0xF) << 12) + ((utf8[offset2] & 0x3F) << 6) + (utf8[offset2 + 1] & 0x3F));
                offset2 += 2;
                continue;
            }
            assert (b < 248) : "b=" + b;
            int ch = ((b & 7) << 18) + ((utf8[offset2] & 0x3F) << 12) + ((utf8[offset2 + 1] & 0x3F) << 6) + (utf8[offset2 + 2] & 0x3F);
            offset2 += 3;
            if ((long)ch < 65535L) {
                out[out_offset++] = (char)ch;
                continue;
            }
            int chHalf = ch - 65536;
            out[out_offset++] = (char)((chHalf >> 10) + 55296);
            out[out_offset++] = (char)(((long)chHalf & 0x3FFL) + 56320L);
        }
        chars2.length = out_offset - chars2.offset;
    }

    public static void UTF8toUTF16(BytesRef bytesRef, CharsRef chars2) {
        UnicodeUtil.UTF8toUTF16(bytesRef.bytes, bytesRef.offset, bytesRef.length, chars2);
    }

    public static boolean validUTF16String(CharSequence s2) {
        int size2 = s2.length();
        for (int i2 = 0; i2 < size2; ++i2) {
            char ch = s2.charAt(i2);
            if (ch >= '\ud800' && ch <= '\udbff') {
                if (i2 < size2 - 1) {
                    char nextCH;
                    if ((nextCH = s2.charAt(++i2)) >= '\udc00' && nextCH <= '\udfff') continue;
                    return false;
                }
                return false;
            }
            if (ch < '\udc00' || ch > '\udfff') continue;
            return false;
        }
        return true;
    }

    public static final class UTF16Result {
        public char[] result = new char[10];
        public int[] offsets = new int[10];
        public int length;

        public void setLength(int newLength) {
            if (this.result.length < newLength) {
                this.result = ArrayUtil.grow(this.result, newLength);
            }
            this.length = newLength;
        }

        public void copyText(UTF16Result other) {
            this.setLength(other.length);
            System.arraycopy(other.result, 0, this.result, 0, this.length);
        }
    }

    public static final class UTF8Result {
        public byte[] result = new byte[10];
        public int length;

        public void setLength(int newLength) {
            if (this.result.length < newLength) {
                this.result = ArrayUtil.grow(this.result, newLength);
            }
            this.length = newLength;
        }
    }
}

