/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;

public final class PagedBytes {
    private final List<byte[]> blocks = new ArrayList<byte[]>();
    private final List<Integer> blockEnd = new ArrayList<Integer>();
    private final int blockSize;
    private final int blockBits;
    private final int blockMask;
    private boolean didSkipBytes;
    private boolean frozen;
    private int upto;
    private byte[] currentBlock;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public PagedBytes(int blockBits) {
        this.blockSize = 1 << blockBits;
        this.blockBits = blockBits;
        this.blockMask = this.blockSize - 1;
        this.upto = this.blockSize;
    }

    public void copy(IndexInput in, long byteCount) throws IOException {
        while (byteCount > 0L) {
            int left2 = this.blockSize - this.upto;
            if (left2 == 0) {
                if (this.currentBlock != null) {
                    this.blocks.add(this.currentBlock);
                    this.blockEnd.add(this.upto);
                }
                this.currentBlock = new byte[this.blockSize];
                this.upto = 0;
                left2 = this.blockSize;
            }
            if ((long)left2 < byteCount) {
                in.readBytes(this.currentBlock, this.upto, left2, false);
                this.upto = this.blockSize;
                byteCount -= (long)left2;
                continue;
            }
            in.readBytes(this.currentBlock, this.upto, (int)byteCount, false);
            this.upto = (int)((long)this.upto + byteCount);
            break;
        }
    }

    public void copy(BytesRef bytes2) throws IOException {
        int byteCount = bytes2.length;
        int bytesUpto = bytes2.offset;
        while (byteCount > 0) {
            int left2 = this.blockSize - this.upto;
            if (left2 == 0) {
                if (this.currentBlock != null) {
                    this.blocks.add(this.currentBlock);
                    this.blockEnd.add(this.upto);
                }
                this.currentBlock = new byte[this.blockSize];
                this.upto = 0;
                left2 = this.blockSize;
            }
            if (left2 < byteCount) {
                System.arraycopy(bytes2.bytes, bytesUpto, this.currentBlock, this.upto, left2);
                this.upto = this.blockSize;
                byteCount -= left2;
                bytesUpto += left2;
                continue;
            }
            System.arraycopy(bytes2.bytes, bytesUpto, this.currentBlock, this.upto, byteCount);
            this.upto += byteCount;
            break;
        }
    }

    public void copy(BytesRef bytes2, BytesRef out) throws IOException {
        int left2 = this.blockSize - this.upto;
        if (bytes2.length > left2 || this.currentBlock == null) {
            if (this.currentBlock != null) {
                this.blocks.add(this.currentBlock);
                this.blockEnd.add(this.upto);
                this.didSkipBytes = true;
            }
            this.currentBlock = new byte[this.blockSize];
            this.upto = 0;
            left2 = this.blockSize;
            assert (bytes2.length <= this.blockSize);
        }
        out.bytes = this.currentBlock;
        out.offset = this.upto;
        out.length = bytes2.length;
        System.arraycopy(bytes2.bytes, bytes2.offset, this.currentBlock, this.upto, bytes2.length);
        this.upto += bytes2.length;
    }

    public Reader freeze(boolean trim) {
        if (this.frozen) {
            throw new IllegalStateException("already frozen");
        }
        if (this.didSkipBytes) {
            throw new IllegalStateException("cannot freeze when copy(BytesRef, BytesRef) was used");
        }
        if (trim && this.upto < this.blockSize) {
            byte[] newBlock = new byte[this.upto];
            System.arraycopy(this.currentBlock, 0, newBlock, 0, this.upto);
            this.currentBlock = newBlock;
        }
        if (this.currentBlock == null) {
            this.currentBlock = EMPTY_BYTES;
        }
        this.blocks.add(this.currentBlock);
        this.blockEnd.add(this.upto);
        this.frozen = true;
        this.currentBlock = null;
        return new Reader(this);
    }

    public long getPointer() {
        if (this.currentBlock == null) {
            return 0L;
        }
        return (long)this.blocks.size() * (long)this.blockSize + (long)this.upto;
    }

    public long copyUsingLengthPrefix(BytesRef bytes2) throws IOException {
        if (bytes2.length >= 32768) {
            throw new IllegalArgumentException("max length is 32767 (got " + bytes2.length + ")");
        }
        if (this.upto + bytes2.length + 2 > this.blockSize) {
            if (bytes2.length + 2 > this.blockSize) {
                throw new IllegalArgumentException("block size " + this.blockSize + " is too small to store length " + bytes2.length + " bytes");
            }
            if (this.currentBlock != null) {
                this.blocks.add(this.currentBlock);
                this.blockEnd.add(this.upto);
            }
            this.currentBlock = new byte[this.blockSize];
            this.upto = 0;
        }
        long pointer2 = this.getPointer();
        if (bytes2.length < 128) {
            this.currentBlock[this.upto++] = (byte)bytes2.length;
        } else {
            this.currentBlock[this.upto++] = (byte)(0x80 | bytes2.length >> 8);
            this.currentBlock[this.upto++] = (byte)(bytes2.length & 0xFF);
        }
        System.arraycopy(bytes2.bytes, bytes2.offset, this.currentBlock, this.upto, bytes2.length);
        this.upto += bytes2.length;
        return pointer2;
    }

    public PagedBytesDataInput getDataInput() {
        if (!this.frozen) {
            throw new IllegalStateException("must call freeze() before getDataInput");
        }
        return new PagedBytesDataInput();
    }

    public PagedBytesDataOutput getDataOutput() {
        if (this.frozen) {
            throw new IllegalStateException("cannot get DataOutput after freeze()");
        }
        return new PagedBytesDataOutput();
    }

    static /* synthetic */ byte[] access$602(PagedBytes x0, byte[] x1) {
        x0.currentBlock = x1;
        return x1;
    }

    public final class PagedBytesDataOutput
    extends DataOutput {
        public void writeByte(byte b) {
            if (PagedBytes.this.upto == PagedBytes.this.blockSize) {
                if (PagedBytes.this.currentBlock != null) {
                    PagedBytes.this.blocks.add(PagedBytes.this.currentBlock);
                    PagedBytes.this.blockEnd.add(PagedBytes.this.upto);
                }
                PagedBytes.access$602(PagedBytes.this, new byte[PagedBytes.this.blockSize]);
                PagedBytes.this.upto = 0;
            }
            ((PagedBytes)PagedBytes.this).currentBlock[((PagedBytes)PagedBytes.this).upto++] = b;
        }

        public void writeBytes(byte[] b, int offset2, int length2) throws IOException {
            int left2;
            assert (b.length >= offset2 + length2);
            if (length2 == 0) {
                return;
            }
            if (PagedBytes.this.upto == PagedBytes.this.blockSize) {
                if (PagedBytes.this.currentBlock != null) {
                    PagedBytes.this.blocks.add(PagedBytes.this.currentBlock);
                    PagedBytes.this.blockEnd.add(PagedBytes.this.upto);
                }
                PagedBytes.access$602(PagedBytes.this, new byte[PagedBytes.this.blockSize]);
                PagedBytes.this.upto = 0;
            }
            int offsetEnd = offset2 + length2;
            while (true) {
                left2 = offsetEnd - offset2;
                int blockLeft = PagedBytes.this.blockSize - PagedBytes.this.upto;
                if (blockLeft >= left2) break;
                System.arraycopy(b, offset2, PagedBytes.this.currentBlock, PagedBytes.this.upto, blockLeft);
                PagedBytes.this.blocks.add(PagedBytes.this.currentBlock);
                PagedBytes.this.blockEnd.add(PagedBytes.this.blockSize);
                PagedBytes.access$602(PagedBytes.this, new byte[PagedBytes.this.blockSize]);
                PagedBytes.this.upto = 0;
                offset2 += blockLeft;
            }
            System.arraycopy(b, offset2, PagedBytes.this.currentBlock, PagedBytes.this.upto, left2);
            PagedBytes.this.upto += left2;
        }

        public long getPosition() {
            if (PagedBytes.this.currentBlock == null) {
                return 0L;
            }
            return (long)PagedBytes.this.blocks.size() * (long)PagedBytes.this.blockSize + (long)PagedBytes.this.upto;
        }
    }

    public final class PagedBytesDataInput
    extends DataInput {
        private int currentBlockIndex;
        private int currentBlockUpto;
        private byte[] currentBlock;

        PagedBytesDataInput() {
            this.currentBlock = (byte[])PagedBytes.this.blocks.get(0);
        }

        public Object clone() {
            PagedBytesDataInput clone = PagedBytes.this.getDataInput();
            clone.setPosition(this.getPosition());
            return clone;
        }

        public long getPosition() {
            return (long)this.currentBlockIndex * (long)PagedBytes.this.blockSize + (long)this.currentBlockUpto;
        }

        public void setPosition(long pos2) {
            this.currentBlockIndex = (int)(pos2 >> PagedBytes.this.blockBits);
            this.currentBlock = (byte[])PagedBytes.this.blocks.get(this.currentBlockIndex);
            this.currentBlockUpto = (int)(pos2 & (long)PagedBytes.this.blockMask);
        }

        public byte readByte() {
            if (this.currentBlockUpto == PagedBytes.this.blockSize) {
                this.nextBlock();
            }
            return this.currentBlock[this.currentBlockUpto++];
        }

        public void readBytes(byte[] b, int offset2, int len) {
            int left2;
            int blockLeft;
            assert (b.length >= offset2 + len);
            int offsetEnd = offset2 + len;
            while ((blockLeft = PagedBytes.this.blockSize - this.currentBlockUpto) < (left2 = offsetEnd - offset2)) {
                System.arraycopy(this.currentBlock, this.currentBlockUpto, b, offset2, blockLeft);
                this.nextBlock();
                offset2 += blockLeft;
            }
            System.arraycopy(this.currentBlock, this.currentBlockUpto, b, offset2, left2);
            this.currentBlockUpto += left2;
        }

        private void nextBlock() {
            ++this.currentBlockIndex;
            this.currentBlockUpto = 0;
            this.currentBlock = (byte[])PagedBytes.this.blocks.get(this.currentBlockIndex);
        }
    }

    public static final class Reader {
        private final byte[][] blocks;
        private final int[] blockEnds;
        private final int blockBits;
        private final int blockMask;
        private final int blockSize;

        public Reader(PagedBytes pagedBytes) {
            int i2;
            this.blocks = new byte[pagedBytes.blocks.size()][];
            for (i2 = 0; i2 < this.blocks.length; ++i2) {
                this.blocks[i2] = (byte[])pagedBytes.blocks.get(i2);
            }
            this.blockEnds = new int[this.blocks.length];
            for (i2 = 0; i2 < this.blockEnds.length; ++i2) {
                this.blockEnds[i2] = (Integer)pagedBytes.blockEnd.get(i2);
            }
            this.blockBits = pagedBytes.blockBits;
            this.blockMask = pagedBytes.blockMask;
            this.blockSize = pagedBytes.blockSize;
        }

        public BytesRef fillSlice(BytesRef b, long start2, int length2) {
            assert (length2 >= 0) : "length=" + length2;
            assert (length2 <= this.blockSize + 1);
            int index2 = (int)(start2 >> this.blockBits);
            int offset2 = (int)(start2 & (long)this.blockMask);
            b.length = length2;
            if (this.blockSize - offset2 >= length2) {
                b.bytes = this.blocks[index2];
                b.offset = offset2;
            } else {
                b.bytes = new byte[length2];
                b.offset = 0;
                System.arraycopy(this.blocks[index2], offset2, b.bytes, 0, this.blockSize - offset2);
                System.arraycopy(this.blocks[1 + index2], 0, b.bytes, this.blockSize - offset2, length2 - (this.blockSize - offset2));
            }
            return b;
        }

        public BytesRef fill(BytesRef b, long start2) {
            int index2 = (int)(start2 >> this.blockBits);
            b.bytes = this.blocks[index2];
            byte[] block = b.bytes;
            int offset2 = (int)(start2 & (long)this.blockMask);
            if ((block[offset2] & 0x80) == 0) {
                b.length = block[offset2];
                b.offset = offset2 + 1;
            } else {
                b.length = (block[offset2] & 0x7F) << 8 | block[1 + offset2] & 0xFF;
                b.offset = offset2 + 2;
                assert (b.length > 0);
            }
            return b;
        }

        public int fillAndGetIndex(BytesRef b, long start2) {
            int index2 = (int)(start2 >> this.blockBits);
            b.bytes = this.blocks[index2];
            byte[] block = b.bytes;
            int offset2 = (int)(start2 & (long)this.blockMask);
            if ((block[offset2] & 0x80) == 0) {
                b.length = block[offset2];
                b.offset = offset2 + 1;
            } else {
                b.length = (block[offset2] & 0x7F) << 8 | block[1 + offset2] & 0xFF;
                b.offset = offset2 + 2;
                assert (b.length > 0);
            }
            return index2;
        }

        public long fillAndGetStart(BytesRef b, long start2) {
            int index2 = (int)(start2 >> this.blockBits);
            b.bytes = this.blocks[index2];
            byte[] block = b.bytes;
            int offset2 = (int)(start2 & (long)this.blockMask);
            if ((block[offset2] & 0x80) == 0) {
                b.length = block[offset2];
                b.offset = offset2 + 1;
                start2 += 1L + (long)b.length;
            } else {
                b.length = (block[offset2] & 0x7F) << 8 | block[1 + offset2] & 0xFF;
                b.offset = offset2 + 2;
                start2 += 2L + (long)b.length;
                assert (b.length > 0);
            }
            return start2;
        }

        public BytesRef fillSliceWithPrefix(BytesRef b, long start2) {
            int length2;
            int index2 = (int)(start2 >> this.blockBits);
            byte[] block = this.blocks[index2];
            int offset2 = (int)(start2 & (long)this.blockMask);
            if ((block[offset2] & 0x80) == 0) {
                length2 = block[offset2];
                ++offset2;
            } else {
                length2 = (block[offset2] & 0x7F) << 8 | block[1 + offset2] & 0xFF;
                offset2 += 2;
                assert (length2 > 0);
            }
            assert (length2 >= 0) : "length=" + length2;
            b.length = length2;
            if (this.blockSize - offset2 >= length2) {
                b.offset = offset2;
                b.bytes = this.blocks[index2];
            } else {
                b.bytes = new byte[length2];
                b.offset = 0;
                System.arraycopy(this.blocks[index2], offset2, b.bytes, 0, this.blockSize - offset2);
                System.arraycopy(this.blocks[1 + index2], 0, b.bytes, this.blockSize - offset2, length2 - (this.blockSize - offset2));
            }
            return b;
        }

        public byte[][] getBlocks() {
            return this.blocks;
        }

        public int[] getBlockEnds() {
            return this.blockEnds;
        }
    }
}

