/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SorterTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtil {
    @Deprecated
    public ArrayUtil() {
    }

    public static int parseInt(char[] chars2) throws NumberFormatException {
        return ArrayUtil.parseInt(chars2, 0, chars2.length, 10);
    }

    public static int parseInt(char[] chars2, int offset2, int len) throws NumberFormatException {
        return ArrayUtil.parseInt(chars2, offset2, len, 10);
    }

    public static int parseInt(char[] chars2, int offset2, int len, int radix) throws NumberFormatException {
        boolean negative;
        if (chars2 == null || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        int i2 = 0;
        if (len == 0) {
            throw new NumberFormatException("chars length is 0");
        }
        boolean bl = negative = chars2[offset2 + i2] == '-';
        if (negative && ++i2 == len) {
            throw new NumberFormatException("can't convert to an int");
        }
        if (negative) {
            ++offset2;
            --len;
        }
        return ArrayUtil.parse(chars2, offset2, len, radix, negative);
    }

    private static int parse(char[] chars2, int offset2, int len, int radix, boolean negative) throws NumberFormatException {
        int max2 = Integer.MIN_VALUE / radix;
        int result2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            int digit = Character.digit(chars2[i2 + offset2], radix);
            if (digit == -1) {
                throw new NumberFormatException("Unable to parse");
            }
            if (max2 > result2) {
                throw new NumberFormatException("Unable to parse");
            }
            int next = result2 * radix - digit;
            if (next > result2) {
                throw new NumberFormatException("Unable to parse");
            }
            result2 = next;
        }
        if (!negative && (result2 = -result2) < 0) {
            throw new NumberFormatException("Unable to parse");
        }
        return result2;
    }

    public static int oversize(int minTargetSize, int bytesPerElement) {
        int newSize;
        if (minTargetSize < 0) {
            throw new IllegalArgumentException("invalid array size " + minTargetSize);
        }
        if (minTargetSize == 0) {
            return 0;
        }
        int extra = minTargetSize >> 3;
        if (extra < 3) {
            extra = 3;
        }
        if ((newSize = minTargetSize + extra) + 7 < 0) {
            return Integer.MAX_VALUE;
        }
        if (Constants.JRE_IS_64BIT) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return newSize + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return newSize + 7 & 0x7FFFFFF8;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 2: {
                return newSize + 1 & 0x7FFFFFFE;
            }
            case 1: {
                return newSize + 3 & 0x7FFFFFFC;
            }
        }
        return newSize;
    }

    public static int getShrinkSize(int currentSize, int targetSize, int bytesPerElement) {
        int newSize = ArrayUtil.oversize(targetSize, bytesPerElement);
        if (newSize < currentSize / 2) {
            return newSize;
        }
        return currentSize;
    }

    public static short[] grow(short[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            short[] newArray = new short[ArrayUtil.oversize(minSize, 2)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static short[] grow(short[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static float[] grow(float[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            float[] newArray = new float[ArrayUtil.oversize(minSize, 4)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static float[] grow(float[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static double[] grow(double[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            double[] newArray = new double[ArrayUtil.oversize(minSize, 8)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static double[] grow(double[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static short[] shrink(short[] array, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize, 2);
        if (newSize != array.length) {
            short[] newArray = new short[newSize];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }

    public static int[] grow(int[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            int[] newArray = new int[ArrayUtil.oversize(minSize, 4)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static int[] grow(int[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static int[] shrink(int[] array, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize, 4);
        if (newSize != array.length) {
            int[] newArray = new int[newSize];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }

    public static long[] grow(long[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            long[] newArray = new long[ArrayUtil.oversize(minSize, 8)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static long[] grow(long[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static long[] shrink(long[] array, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize, 8);
        if (newSize != array.length) {
            long[] newArray = new long[newSize];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }

    public static byte[] grow(byte[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            byte[] newArray = new byte[ArrayUtil.oversize(minSize, 1)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static byte[] grow(byte[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static byte[] shrink(byte[] array, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize, 1);
        if (newSize != array.length) {
            byte[] newArray = new byte[newSize];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }

    public static boolean[] grow(boolean[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            boolean[] newArray = new boolean[ArrayUtil.oversize(minSize, 1)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static boolean[] grow(boolean[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static boolean[] shrink(boolean[] array, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize, 1);
        if (newSize != array.length) {
            boolean[] newArray = new boolean[newSize];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }

    public static char[] grow(char[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            char[] newArray = new char[ArrayUtil.oversize(minSize, 2)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static char[] grow(char[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static char[] shrink(char[] array, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize, 2);
        if (newSize != array.length) {
            char[] newArray = new char[newSize];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }

    public static int[][] grow(int[][] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            int[][] newArray = new int[ArrayUtil.oversize(minSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static int[][] grow(int[][] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static int[][] shrink(int[][] array, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        if (newSize != array.length) {
            int[][] newArray = new int[newSize][];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }

    public static float[][] grow(float[][] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            float[][] newArray = new float[ArrayUtil.oversize(minSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static float[][] grow(float[][] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static float[][] shrink(float[][] array, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array.length, targetSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        if (newSize != array.length) {
            float[][] newArray = new float[newSize][];
            System.arraycopy(array, 0, newArray, 0, newSize);
            return newArray;
        }
        return array;
    }

    public static int hashCode(char[] array, int start2, int end2) {
        int code = 0;
        for (int i2 = end2 - 1; i2 >= start2; --i2) {
            code = code * 31 + array[i2];
        }
        return code;
    }

    public static int hashCode(byte[] array, int start2, int end2) {
        int code = 0;
        for (int i2 = end2 - 1; i2 >= start2; --i2) {
            code = code * 31 + array[i2];
        }
        return code;
    }

    public static boolean equals(char[] left2, int offsetLeft, char[] right, int offsetRight, int length2) {
        if (offsetLeft + length2 <= left2.length && offsetRight + length2 <= right.length) {
            for (int i2 = 0; i2 < length2; ++i2) {
                if (left2[offsetLeft + i2] == right[offsetRight + i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(int[] left2, int offsetLeft, int[] right, int offsetRight, int length2) {
        if (offsetLeft + length2 <= left2.length && offsetRight + length2 <= right.length) {
            for (int i2 = 0; i2 < length2; ++i2) {
                if (left2[offsetLeft + i2] == right[offsetRight + i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int[] toIntArray(Collection<Integer> ints) {
        int[] result2 = new int[ints.size()];
        int upto2 = 0;
        for (int v : ints) {
            result2[upto2++] = v;
        }
        assert (upto2 == result2.length);
        return result2;
    }

    private static <T> SorterTemplate getSorter(final T[] a, final Comparator<? super T> comp) {
        return new SorterTemplate(){
            private T pivot;

            protected void swap(int i2, int j) {
                Object o = a[i2];
                a[i2] = a[j];
                a[j] = o;
            }

            protected int compare(int i2, int j) {
                return comp.compare(a[i2], a[j]);
            }

            protected void setPivot(int i2) {
                this.pivot = a[i2];
            }

            protected int comparePivot(int j) {
                return comp.compare(this.pivot, a[j]);
            }
        };
    }

    private static <T extends Comparable<? super T>> SorterTemplate getSorter(T[] a) {
        return new SorterTemplate((Comparable[])a){
            private T pivot;
            final /* synthetic */ Comparable[] val$a;
            {
                this.val$a = comparableArray;
            }

            protected void swap(int i2, int j) {
                Comparable o = this.val$a[i2];
                this.val$a[i2] = this.val$a[j];
                this.val$a[j] = o;
            }

            protected int compare(int i2, int j) {
                return this.val$a[i2].compareTo(this.val$a[j]);
            }

            protected void setPivot(int i2) {
                this.pivot = this.val$a[i2];
            }

            protected int comparePivot(int j) {
                return this.pivot.compareTo((Comparable)this.val$a[j]);
            }
        };
    }

    public static <T> void quickSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> comp) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.getSorter(a, comp).quickSort(fromIndex, toIndex - 1);
    }

    public static <T> void quickSort(T[] a, Comparator<? super T> comp) {
        ArrayUtil.quickSort(a, 0, a.length, comp);
    }

    public static <T extends Comparable<? super T>> void quickSort(T[] a, int fromIndex, int toIndex) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.getSorter(a).quickSort(fromIndex, toIndex - 1);
    }

    public static <T extends Comparable<? super T>> void quickSort(T[] a) {
        ArrayUtil.quickSort(a, (int)0, (int)a.length);
    }

    public static <T> void mergeSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> comp) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.getSorter(a, comp).mergeSort(fromIndex, toIndex - 1);
    }

    public static <T> void mergeSort(T[] a, Comparator<? super T> comp) {
        ArrayUtil.mergeSort(a, 0, a.length, comp);
    }

    public static <T extends Comparable<? super T>> void mergeSort(T[] a, int fromIndex, int toIndex) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.getSorter(a).mergeSort(fromIndex, toIndex - 1);
    }

    public static <T extends Comparable<? super T>> void mergeSort(T[] a) {
        ArrayUtil.mergeSort(a, (int)0, (int)a.length);
    }

    public static <T> void insertionSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> comp) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.getSorter(a, comp).insertionSort(fromIndex, toIndex - 1);
    }

    public static <T> void insertionSort(T[] a, Comparator<? super T> comp) {
        ArrayUtil.insertionSort(a, 0, a.length, comp);
    }

    public static <T extends Comparable<? super T>> void insertionSort(T[] a, int fromIndex, int toIndex) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.getSorter(a).insertionSort(fromIndex, toIndex - 1);
    }

    public static <T extends Comparable<? super T>> void insertionSort(T[] a) {
        ArrayUtil.insertionSort(a, (int)0, (int)a.length);
    }
}

