/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.TrackingMergeScheduler;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.StoreRateLimiting;
import org.apache.lucene.store.XFSIndexOutput;
import org.elasticsearch.common.RateLimiter;

public class XNIOFSDirectory
extends NIOFSDirectory {
    private final StoreRateLimiting.Provider rateLimitingProvider;
    private final StoreRateLimiting.Listener rateListener;

    public XNIOFSDirectory(File path2, LockFactory lockFactory, StoreRateLimiting.Provider rateLimitingProvider, StoreRateLimiting.Listener rateListener) throws IOException {
        super(path2, lockFactory);
        this.rateLimitingProvider = rateLimitingProvider;
        this.rateListener = rateListener;
    }

    @Override
    public IndexOutput createOutput(String name2) throws IOException {
        StoreRateLimiting rateLimiting = this.rateLimitingProvider.rateLimiting();
        StoreRateLimiting.Type type2 = rateLimiting.getType();
        RateLimiter limiter = rateLimiting.getRateLimiter();
        if (type2 == StoreRateLimiting.Type.NONE || limiter == null) {
            return super.createOutput(name2);
        }
        if (TrackingMergeScheduler.getCurrentMerge() != null) {
            this.ensureOpen();
            this.ensureCanWrite(name2);
            return new XFSIndexOutput(this, name2, limiter, this.rateListener);
        }
        if (type2 == StoreRateLimiting.Type.ALL) {
            this.ensureOpen();
            this.ensureCanWrite(name2);
            return new XFSIndexOutput(this, name2, limiter, this.rateListener);
        }
        return super.createOutput(name2);
    }
}

