/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;

public class RAMOutputStream
extends IndexOutput {
    static final int BUFFER_SIZE = 1024;
    private RAMFile file;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;

    public RAMOutputStream() {
        this(new RAMFile());
    }

    public RAMOutputStream(RAMFile f) {
        this.file = f;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
    }

    public void writeTo(IndexOutput out) throws IOException {
        this.flush();
        long end2 = this.file.length;
        long pos2 = 0L;
        int buffer = 0;
        while (pos2 < end2) {
            int length2 = 1024;
            long nextPos = pos2 + (long)length2;
            if (nextPos > end2) {
                length2 = (int)(end2 - pos2);
            }
            out.writeBytes(this.file.getBuffer(buffer++), length2);
            pos2 = nextPos;
        }
    }

    public void reset() {
        this.currentBuffer = null;
        this.currentBufferIndex = -1;
        this.bufferPosition = 0;
        this.bufferStart = 0L;
        this.bufferLength = 0;
        this.file.setLength(0L);
    }

    public void close() throws IOException {
        this.flush();
    }

    public void seek(long pos2) throws IOException {
        this.setFileLength();
        if (pos2 < this.bufferStart || pos2 >= this.bufferStart + (long)this.bufferLength) {
            this.currentBufferIndex = (int)(pos2 / 1024L);
            this.switchCurrentBuffer();
        }
        this.bufferPosition = (int)(pos2 % 1024L);
    }

    public long length() {
        return this.file.length;
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition == this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer();
        }
        this.currentBuffer[this.bufferPosition++] = b;
    }

    public void writeBytes(byte[] b, int offset2, int len) throws IOException {
        assert (b != null);
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition == this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            int bytesToCopy = len < (remainInBuffer = this.currentBuffer.length - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(b, offset2, this.currentBuffer, this.bufferPosition, bytesToCopy);
            offset2 += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    private final void switchCurrentBuffer() throws IOException {
        this.currentBuffer = this.currentBufferIndex == this.file.numBuffers() ? this.file.addBuffer(1024) : this.file.getBuffer(this.currentBufferIndex);
        this.bufferPosition = 0;
        this.bufferStart = 1024L * (long)this.currentBufferIndex;
        this.bufferLength = this.currentBuffer.length;
    }

    private void setFileLength() {
        long pointer2 = this.bufferStart + (long)this.bufferPosition;
        if (pointer2 > this.file.length) {
            this.file.setLength(pointer2);
        }
    }

    public void flush() throws IOException {
        this.file.setLastModified(System.currentTimeMillis());
        this.setFileLength();
    }

    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    public long sizeInBytes() {
        return (long)this.file.numBuffers() * 1024L;
    }

    public void copyBytes(DataInput input, long numBytes) throws IOException {
        assert (numBytes >= 0L) : "numBytes=" + numBytes;
        while (numBytes > 0L) {
            int toCopy;
            if (this.bufferPosition == this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            if (numBytes < (long)(toCopy = this.currentBuffer.length - this.bufferPosition)) {
                toCopy = (int)numBytes;
            }
            input.readBytes(this.currentBuffer, this.bufferPosition, toCopy, false);
            numBytes -= (long)toCopy;
            this.bufferPosition += toCopy;
        }
    }
}

