/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSDirectory;

public class NIOFSDirectory
extends FSDirectory {
    public NIOFSDirectory(File path2, LockFactory lockFactory) throws IOException {
        super(path2, lockFactory);
    }

    public NIOFSDirectory(File path2) throws IOException {
        super(path2, null);
    }

    public IndexInput openInput(String name2, int bufferSize) throws IOException {
        this.ensureOpen();
        return new NIOFSIndexInput(new File(this.getDirectory(), name2), bufferSize, this.getReadChunkSize());
    }

    protected static class NIOFSIndexInput
    extends SimpleFSDirectory.SimpleFSIndexInput {
        private ByteBuffer byteBuf;
        private byte[] otherBuffer;
        private ByteBuffer otherByteBuf;
        final FileChannel channel;

        public NIOFSIndexInput(File path2, int bufferSize, int chunkSize) throws IOException {
            super("NIOFSIndexInput(path=\"" + path2 + "\")", path2, bufferSize, chunkSize);
            this.channel = this.file.getChannel();
        }

        protected void newBuffer(byte[] newBuffer) {
            super.newBuffer(newBuffer);
            this.byteBuf = ByteBuffer.wrap(newBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.isClone && this.file.isOpen) {
                try {
                    this.channel.close();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.file.close();
                    throw throwable;
                }
                this.file.close();
                {
                }
            }
        }

        protected void readInternal(byte[] b, int offset2, int len) throws IOException {
            int readLength;
            ByteBuffer bb;
            if (b == this.buffer && 0 == offset2) {
                assert (this.byteBuf != null);
                this.byteBuf.clear();
                this.byteBuf.limit(len);
                bb = this.byteBuf;
            } else if (offset2 == 0) {
                if (this.otherBuffer != b) {
                    this.otherBuffer = b;
                    this.otherByteBuf = ByteBuffer.wrap(b);
                } else {
                    this.otherByteBuf.clear();
                }
                this.otherByteBuf.limit(len);
                bb = this.otherByteBuf;
            } else {
                bb = ByteBuffer.wrap(b, offset2, len);
            }
            int readOffset = bb.position();
            assert (readLength == len);
            long pos2 = this.getFilePointer();
            try {
                int i2;
                for (readLength = bb.limit() - readOffset; readLength > 0; readLength -= i2) {
                    int limit2 = readLength > this.chunkSize ? readOffset + this.chunkSize : readOffset + readLength;
                    bb.limit(limit2);
                    i2 = this.channel.read(bb, pos2);
                    if (i2 == -1) {
                        throw new EOFException("read past EOF: " + this);
                    }
                    pos2 += (long)i2;
                    readOffset += i2;
                }
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryError outOfMemoryError = new OutOfMemoryError("OutOfMemoryError likely caused by the Sun VM Bug described in https://issues.apache.org/jira/browse/LUCENE-1566; try calling FSDirectory.setReadChunkSize with a value smaller than the current chunk size (" + this.chunkSize + ")");
                outOfMemoryError.initCause(e);
                throw outOfMemoryError;
            }
            catch (IOException ioe) {
                IOException newIOE = new IOException(ioe.getMessage() + ": " + this);
                newIOE.initCause(ioe);
                throw newIOE;
            }
        }
    }
}

