/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.NoSuchDirectoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSwitchDirectory
extends Directory {
    private final Directory secondaryDir;
    private final Directory primaryDir;
    private final Set<String> primaryExtensions;
    private boolean doClose;

    public FileSwitchDirectory(Set<String> primaryExtensions, Directory primaryDir, Directory secondaryDir, boolean doClose) {
        this.primaryExtensions = primaryExtensions;
        this.primaryDir = primaryDir;
        this.secondaryDir = secondaryDir;
        this.doClose = doClose;
        this.lockFactory = primaryDir.getLockFactory();
    }

    public Directory getPrimaryDir() {
        return this.primaryDir;
    }

    public Directory getSecondaryDir() {
        return this.secondaryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.doClose) {
            try {
                this.secondaryDir.close();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.primaryDir.close();
                throw throwable;
            }
            this.primaryDir.close();
            this.doClose = false;
        }
    }

    @Override
    public String[] listAll() throws IOException {
        NoSuchDirectoryException exc;
        HashSet<String> files;
        block8: {
            files = new HashSet<String>();
            exc = null;
            try {
                for (String f : this.primaryDir.listAll()) {
                    files.add(f);
                }
            }
            catch (NoSuchDirectoryException e) {
                exc = e;
            }
            try {
                for (String f : this.secondaryDir.listAll()) {
                    files.add(f);
                }
            }
            catch (NoSuchDirectoryException e) {
                if (exc != null) {
                    throw exc;
                }
                if (!files.isEmpty()) break block8;
                throw e;
            }
        }
        if (exc != null && files.isEmpty()) {
            throw exc;
        }
        return files.toArray(new String[files.size()]);
    }

    public static String getExtension(String name2) {
        int i2 = name2.lastIndexOf(46);
        if (i2 == -1) {
            return "";
        }
        return name2.substring(i2 + 1, name2.length());
    }

    private Directory getDirectory(String name2) {
        String ext2 = FileSwitchDirectory.getExtension(name2);
        if (this.primaryExtensions.contains(ext2)) {
            return this.primaryDir;
        }
        return this.secondaryDir;
    }

    @Override
    public boolean fileExists(String name2) throws IOException {
        return this.getDirectory(name2).fileExists(name2);
    }

    @Override
    public long fileModified(String name2) throws IOException {
        return this.getDirectory(name2).fileModified(name2);
    }

    @Override
    @Deprecated
    public void touchFile(String name2) throws IOException {
        this.getDirectory(name2).touchFile(name2);
    }

    @Override
    public void deleteFile(String name2) throws IOException {
        this.getDirectory(name2).deleteFile(name2);
    }

    @Override
    public long fileLength(String name2) throws IOException {
        return this.getDirectory(name2).fileLength(name2);
    }

    @Override
    public IndexOutput createOutput(String name2) throws IOException {
        return this.getDirectory(name2).createOutput(name2);
    }

    @Override
    @Deprecated
    public void sync(String name2) throws IOException {
        this.sync(Collections.singleton(name2));
    }

    @Override
    public void sync(Collection<String> names2) throws IOException {
        ArrayList<String> primaryNames = new ArrayList<String>();
        ArrayList<String> secondaryNames = new ArrayList<String>();
        for (String name2 : names2) {
            if (this.primaryExtensions.contains(FileSwitchDirectory.getExtension(name2))) {
                primaryNames.add(name2);
                continue;
            }
            secondaryNames.add(name2);
        }
        this.primaryDir.sync(primaryNames);
        this.secondaryDir.sync(secondaryNames);
    }

    @Override
    public IndexInput openInput(String name2) throws IOException {
        return this.getDirectory(name2).openInput(name2);
    }
}

