/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.ThreadInterruptedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FSDirectory
extends Directory {
    public static final int DEFAULT_READ_CHUNK_SIZE = Constants.JRE_IS_64BIT ? Integer.MAX_VALUE : 0x6400000;
    protected final File directory;
    protected final Set<String> staleFiles = Collections.synchronizedSet(new HashSet());
    private int chunkSize = DEFAULT_READ_CHUNK_SIZE;

    private static File getCanonicalPath(File file2) throws IOException {
        return new File(file2.getCanonicalPath());
    }

    protected FSDirectory(File path2, LockFactory lockFactory) throws IOException {
        if (lockFactory == null) {
            lockFactory = new NativeFSLockFactory();
        }
        this.directory = FSDirectory.getCanonicalPath(path2);
        if (this.directory.exists() && !this.directory.isDirectory()) {
            throw new NoSuchDirectoryException("file '" + this.directory + "' exists but is not a directory");
        }
        this.setLockFactory(lockFactory);
    }

    public static FSDirectory open(File path2) throws IOException {
        return FSDirectory.open(path2, null);
    }

    public static FSDirectory open(File path2, LockFactory lockFactory) throws IOException {
        if ((Constants.WINDOWS || Constants.SUN_OS || Constants.LINUX) && Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            return new MMapDirectory(path2, lockFactory);
        }
        if (Constants.WINDOWS) {
            return new SimpleFSDirectory(path2, lockFactory);
        }
        return new NIOFSDirectory(path2, lockFactory);
    }

    @Override
    public void setLockFactory(LockFactory lockFactory) throws IOException {
        super.setLockFactory(lockFactory);
        if (lockFactory instanceof FSLockFactory) {
            FSLockFactory lf = (FSLockFactory)lockFactory;
            File dir = lf.getLockDir();
            if (dir == null) {
                lf.setLockDir(this.directory);
                lf.setLockPrefix(null);
            } else if (dir.getCanonicalPath().equals(this.directory.getCanonicalPath())) {
                lf.setLockPrefix(null);
            }
        }
    }

    public static String[] listAll(File dir) throws IOException {
        if (!dir.exists()) {
            throw new NoSuchDirectoryException("directory '" + dir + "' does not exist");
        }
        if (!dir.isDirectory()) {
            throw new NoSuchDirectoryException("file '" + dir + "' exists but is not a directory");
        }
        String[] result2 = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String file2) {
                return !new File(dir, file2).isDirectory();
            }
        });
        if (result2 == null) {
            throw new IOException("directory '" + dir + "' exists and is a directory, but cannot be listed: list() returned null");
        }
        return result2;
    }

    @Override
    public String[] listAll() throws IOException {
        this.ensureOpen();
        return FSDirectory.listAll(this.directory);
    }

    @Override
    public boolean fileExists(String name2) {
        this.ensureOpen();
        File file2 = new File(this.directory, name2);
        return file2.exists();
    }

    @Override
    public long fileModified(String name2) {
        this.ensureOpen();
        File file2 = new File(this.directory, name2);
        return file2.lastModified();
    }

    public static long fileModified(File directory, String name2) {
        File file2 = new File(directory, name2);
        return file2.lastModified();
    }

    @Override
    @Deprecated
    public void touchFile(String name2) {
        this.ensureOpen();
        File file2 = new File(this.directory, name2);
        file2.setLastModified(System.currentTimeMillis());
    }

    @Override
    public long fileLength(String name2) throws IOException {
        this.ensureOpen();
        File file2 = new File(this.directory, name2);
        long len = file2.length();
        if (len == 0L && !file2.exists()) {
            throw new FileNotFoundException(name2);
        }
        return len;
    }

    @Override
    public void deleteFile(String name2) throws IOException {
        this.ensureOpen();
        File file2 = new File(this.directory, name2);
        if (!file2.delete()) {
            throw new IOException("Cannot delete " + file2);
        }
        this.staleFiles.remove(name2);
    }

    @Override
    public IndexOutput createOutput(String name2) throws IOException {
        this.ensureOpen();
        this.ensureCanWrite(name2);
        return new FSIndexOutput(this, name2);
    }

    protected void ensureCanWrite(String name2) throws IOException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Cannot create directory: " + this.directory);
        }
        File file2 = new File(this.directory, name2);
        if (file2.exists() && !file2.delete()) {
            throw new IOException("Cannot overwrite: " + file2);
        }
    }

    protected void onIndexOutputClosed(FSIndexOutput io2) {
        this.staleFiles.add(io2.name);
    }

    @Override
    @Deprecated
    public void sync(String name2) throws IOException {
        this.sync(Collections.singleton(name2));
    }

    @Override
    public void sync(Collection<String> names2) throws IOException {
        this.ensureOpen();
        HashSet<String> toSync = new HashSet<String>(names2);
        toSync.retainAll(this.staleFiles);
        for (String name2 : toSync) {
            this.fsync(name2);
        }
        this.staleFiles.removeAll(toSync);
    }

    @Override
    public IndexInput openInput(String name2) throws IOException {
        this.ensureOpen();
        return this.openInput(name2, 1024);
    }

    @Override
    public String getLockID() {
        String dirName;
        this.ensureOpen();
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        int digest2 = 0;
        for (int charIDX = 0; charIDX < dirName.length(); ++charIDX) {
            char ch = dirName.charAt(charIDX);
            digest2 = 31 * digest2 + ch;
        }
        return "lucene-" + Integer.toHexString(digest2);
    }

    @Override
    public synchronized void close() {
        this.isOpen = false;
    }

    @Deprecated
    public File getFile() {
        return this.getDirectory();
    }

    public File getDirectory() {
        this.ensureOpen();
        return this.directory;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + this.directory + " lockFactory=" + this.getLockFactory();
    }

    public final void setReadChunkSize(int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be positive");
        }
        if (!Constants.JRE_IS_64BIT) {
            this.chunkSize = chunkSize;
        }
    }

    public final int getReadChunkSize() {
        return this.chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fsync(String name2) throws IOException {
        File fullFile = new File(this.directory, name2);
        boolean success2 = false;
        int retryCount = 0;
        IOException exc = null;
        while (!success2 && retryCount < 5) {
            ++retryCount;
            RandomAccessFile file2 = null;
            try {
                Object var8_9;
                try {
                    file2 = new RandomAccessFile(fullFile, "rw");
                    file2.getFD().sync();
                    success2 = true;
                    var8_9 = null;
                    if (file2 == null) continue;
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    if (file2 != null) {
                        file2.close();
                    }
                    throw throwable;
                }
                file2.close();
                {
                }
            }
            catch (IOException ioe) {
                if (exc == null) {
                    exc = ioe;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    throw new ThreadInterruptedException(ie);
                }
            }
        }
        if (!success2) {
            throw exc;
        }
    }

    protected static class FSIndexOutput
    extends BufferedIndexOutput {
        private final FSDirectory parent;
        private final String name;
        private final RandomAccessFile file;
        private volatile boolean isOpen;

        public FSIndexOutput(FSDirectory parent, String name2) throws IOException {
            this.parent = parent;
            this.name = name2;
            this.file = new RandomAccessFile(new File(parent.directory, name2), "rw");
            this.isOpen = true;
        }

        public void flushBuffer(byte[] b, int offset2, int size2) throws IOException {
            this.file.write(b, offset2, size2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            block6: {
                this.parent.onIndexOutputClosed(this);
                if (!this.isOpen) return;
                boolean success2 = false;
                try {
                    super.close();
                    success2 = true;
                    Object var3_2 = null;
                    this.isOpen = false;
                    if (success2) break block6;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.isOpen = false;
                    if (success2) {
                        this.file.close();
                        throw throwable;
                    }
                    try {
                        this.file.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        throw throwable;
                    }
                }
                try {}
                catch (Throwable t) {
                    return;
                }
                this.file.close();
                return;
            }
            this.file.close();
        }

        public void seek(long pos2) throws IOException {
            super.seek(pos2);
            this.file.seek(pos2);
        }

        public long length() throws IOException {
            return this.file.length();
        }

        public void setLength(long length2) throws IOException {
            this.file.setLength(length2);
        }
    }
}

