/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Directory
implements Closeable {
    protected volatile boolean isOpen = true;
    protected LockFactory lockFactory;

    public abstract String[] listAll() throws IOException;

    public abstract boolean fileExists(String var1) throws IOException;

    @Deprecated
    public abstract long fileModified(String var1) throws IOException;

    @Deprecated
    public abstract void touchFile(String var1) throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1) throws IOException;

    @Deprecated
    public void sync(String name2) throws IOException {
    }

    public void sync(Collection<String> names2) throws IOException {
        for (String name2 : names2) {
            this.sync(name2);
        }
    }

    public abstract IndexInput openInput(String var1) throws IOException;

    public IndexInput openInput(String name2, int bufferSize) throws IOException {
        return this.openInput(name2);
    }

    public Lock makeLock(String name2) {
        return this.lockFactory.makeLock(name2);
    }

    public void clearLock(String name2) throws IOException {
        if (this.lockFactory != null) {
            this.lockFactory.clearLock(name2);
        }
    }

    @Override
    public abstract void close() throws IOException;

    public void setLockFactory(LockFactory lockFactory) throws IOException {
        assert (lockFactory != null);
        this.lockFactory = lockFactory;
        lockFactory.setLockPrefix(this.getLockID());
    }

    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public String getLockID() {
        return this.toString();
    }

    public String toString() {
        return super.toString() + " lockFactory=" + this.getLockFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(Directory to, String src, String dest) throws IOException {
        IndexOutput os = null;
        IndexInput is = null;
        IOException priorException = null;
        try {
            os = to.createOutput(dest);
            is = this.openInput(src);
            is.copyBytes(os, is.length());
        }
        catch (IOException ioe) {
            try {
                priorException = ioe;
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(priorException, os, is);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(priorException, os, is);
        }
        IOUtils.closeWhileHandlingException(priorException, os, is);
    }

    @Deprecated
    public static void copy(Directory src, Directory dest, boolean closeDirSrc) throws IOException {
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        for (String file2 : src.listAll()) {
            if (!filter.accept(null, file2)) continue;
            src.copy(dest, file2, file2);
        }
        if (closeDirSrc) {
            src.close();
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }
}

