/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataOutput {
    private static int COPY_BUFFER_SIZE = 16384;
    private byte[] copyBuffer;

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b, int length2) throws IOException {
        this.writeBytes(b, 0, length2);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeInt(int i2) throws IOException {
        this.writeByte((byte)(i2 >> 24));
        this.writeByte((byte)(i2 >> 16));
        this.writeByte((byte)(i2 >> 8));
        this.writeByte((byte)i2);
    }

    public void writeShort(short i2) throws IOException {
        this.writeByte((byte)(i2 >> 8));
        this.writeByte((byte)i2);
    }

    public final void writeVInt(int i2) throws IOException {
        while ((i2 & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i2 & 0x7F | 0x80));
            i2 >>>= 7;
        }
        this.writeByte((byte)i2);
    }

    public void writeLong(long i2) throws IOException {
        this.writeInt((int)(i2 >> 32));
        this.writeInt((int)i2);
    }

    public final void writeVLong(long i2) throws IOException {
        assert (i2 >= 0L);
        while ((i2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i2 & 0x7FL | 0x80L));
            i2 >>>= 7;
        }
        this.writeByte((byte)i2);
    }

    public void writeString(String s2) throws IOException {
        BytesRef utf8Result = new BytesRef(10);
        UnicodeUtil.UTF16toUTF8((CharSequence)s2, 0, s2.length(), utf8Result);
        this.writeVInt(utf8Result.length);
        this.writeBytes(utf8Result.bytes, 0, utf8Result.length);
    }

    public void copyBytes(DataInput input, long numBytes) throws IOException {
        assert (numBytes >= 0L) : "numBytes=" + numBytes;
        long left2 = numBytes;
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[COPY_BUFFER_SIZE];
        }
        while (left2 > 0L) {
            int toCopy = left2 > (long)COPY_BUFFER_SIZE ? COPY_BUFFER_SIZE : (int)left2;
            input.readBytes(this.copyBuffer, 0, toCopy);
            this.writeBytes(this.copyBuffer, 0, toCopy);
            left2 -= (long)toCopy;
        }
    }

    @Deprecated
    public void writeChars(String s2, int start2, int length2) throws IOException {
        int end2 = start2 + length2;
        for (int i2 = start2; i2 < end2; ++i2) {
            char code = s2.charAt(i2);
            if (code >= '\u0001' && code <= '\u007f') {
                this.writeByte((byte)code);
                continue;
            }
            if (code >= '\u0080' && code <= '\u07ff' || code == '\u0000') {
                this.writeByte((byte)(0xC0 | code >> 6));
                this.writeByte((byte)(0x80 | code & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xE0 | code >>> 12));
            this.writeByte((byte)(0x80 | code >> 6 & 0x3F));
            this.writeByte((byte)(0x80 | code & 0x3F));
        }
    }

    @Deprecated
    public void writeChars(char[] s2, int start2, int length2) throws IOException {
        int end2 = start2 + length2;
        for (int i2 = start2; i2 < end2; ++i2) {
            char code = s2[i2];
            if (code >= '\u0001' && code <= '\u007f') {
                this.writeByte((byte)code);
                continue;
            }
            if (code >= '\u0080' && code <= '\u07ff' || code == '\u0000') {
                this.writeByte((byte)(0xC0 | code >> 6));
                this.writeByte((byte)(0x80 | code & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xE0 | code >>> 12));
            this.writeByte((byte)(0x80 | code >> 6 & 0x3F));
            this.writeByte((byte)(0x80 | code & 0x3F));
        }
    }

    public void writeStringStringMap(Map<String, String> map) throws IOException {
        if (map == null) {
            this.writeInt(0);
        } else {
            this.writeInt(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.writeString(entry.getKey());
                this.writeString(entry.getValue());
            }
        }
    }
}

