/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataInput
implements Cloneable {
    private boolean preUTF8Strings;

    public void setModifiedUTF8StringsMode() {
        this.preUTF8Strings = true;
    }

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public void readBytes(byte[] b, int offset2, int len, boolean useBuffer) throws IOException {
        this.readBytes(b, offset2, len);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i2 = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= (b & 0xF) << 28;
        if ((b & 0xF0) == 0) {
            return i2;
        }
        throw new IOException("Invalid vInt detected (too many bits)");
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i2 = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.readByte();
        i2 |= ((long)b & 0x7FL) << 56;
        if ((b & 0x80) == 0) {
            return i2;
        }
        throw new IOException("Invalid vLong detected (negative values disallowed)");
    }

    public String readString() throws IOException {
        if (this.preUTF8Strings) {
            return this.readModifiedUTF8String();
        }
        int length2 = this.readVInt();
        byte[] bytes2 = new byte[length2];
        this.readBytes(bytes2, 0, length2);
        return new String(bytes2, 0, length2, "UTF-8");
    }

    private String readModifiedUTF8String() throws IOException {
        int length2 = this.readVInt();
        char[] chars2 = new char[length2];
        this.readChars(chars2, 0, length2);
        return new String(chars2, 0, length2);
    }

    @Deprecated
    public void readChars(char[] buffer, int start2, int length2) throws IOException {
        int end2 = start2 + length2;
        for (int i2 = start2; i2 < end2; ++i2) {
            byte b = this.readByte();
            buffer[i2] = (b & 0x80) == 0 ? (char)(b & 0x7F) : ((b & 0xE0) != 224 ? (char)((b & 0x1F) << 6 | this.readByte() & 0x3F) : (char)((b & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | this.readByte() & 0x3F));
        }
    }

    public Object clone() {
        DataInput clone = null;
        try {
            clone = (DataInput)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public Map<String, String> readStringStringMap() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        int count2 = this.readInt();
        for (int i2 = 0; i2 < count2; ++i2) {
            String key2 = this.readString();
            String val = this.readString();
            map.put(key2, val);
        }
        return map;
    }
}

