/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;

public abstract class BufferedIndexOutput
extends IndexOutput {
    static final int BUFFER_SIZE = 16384;
    private final byte[] buffer = new byte[16384];
    private long bufferStart = 0L;
    private int bufferPosition = 0;

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition >= 16384) {
            this.flush();
        }
        this.buffer[this.bufferPosition++] = b;
    }

    public void writeBytes(byte[] b, int offset2, int length2) throws IOException {
        int bytesLeft = 16384 - this.bufferPosition;
        if (bytesLeft >= length2) {
            System.arraycopy(b, offset2, this.buffer, this.bufferPosition, length2);
            this.bufferPosition += length2;
            if (16384 - this.bufferPosition == 0) {
                this.flush();
            }
        } else if (length2 > 16384) {
            if (this.bufferPosition > 0) {
                this.flush();
            }
            this.flushBuffer(b, offset2, length2);
            this.bufferStart += (long)length2;
        } else {
            int pos2 = 0;
            while (pos2 < length2) {
                int pieceLength = length2 - pos2 < bytesLeft ? length2 - pos2 : bytesLeft;
                System.arraycopy(b, pos2 + offset2, this.buffer, this.bufferPosition, pieceLength);
                pos2 += pieceLength;
                this.bufferPosition += pieceLength;
                bytesLeft = 16384 - this.bufferPosition;
                if (bytesLeft != 0) continue;
                this.flush();
                bytesLeft = 16384;
            }
        }
    }

    public void flush() throws IOException {
        this.flushBuffer(this.buffer, this.bufferPosition);
        this.bufferStart += (long)this.bufferPosition;
        this.bufferPosition = 0;
    }

    private void flushBuffer(byte[] b, int len) throws IOException {
        this.flushBuffer(b, 0, len);
    }

    protected abstract void flushBuffer(byte[] var1, int var2, int var3) throws IOException;

    public void close() throws IOException {
        this.flush();
    }

    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public void seek(long pos2) throws IOException {
        this.flush();
        this.bufferStart = pos2;
    }

    public abstract long length() throws IOException;
}

