/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBoundaryScanner
implements BoundaryScanner {
    public static final int DEFAULT_MAX_SCAN = 20;
    public static final Character[] DEFAULT_BOUNDARY_CHARS = new Character[]{Character.valueOf('.'), Character.valueOf(','), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n')};
    protected int maxScan;
    protected Set<Character> boundaryChars;

    public SimpleBoundaryScanner() {
        this(20, DEFAULT_BOUNDARY_CHARS);
    }

    public SimpleBoundaryScanner(int maxScan) {
        this(maxScan, DEFAULT_BOUNDARY_CHARS);
    }

    public SimpleBoundaryScanner(Character[] boundaryChars) {
        this(20, boundaryChars);
    }

    public SimpleBoundaryScanner(int maxScan, Character[] boundaryChars) {
        this.maxScan = maxScan;
        this.boundaryChars = new HashSet<Character>();
        this.boundaryChars.addAll(Arrays.asList(boundaryChars));
    }

    public SimpleBoundaryScanner(int maxScan, Set<Character> boundaryChars) {
        this.maxScan = maxScan;
        this.boundaryChars = boundaryChars;
    }

    @Override
    public int findStartOffset(StringBuilder buffer, int start2) {
        int offset2;
        if (start2 > buffer.length() || start2 < 1) {
            return start2;
        }
        int count2 = this.maxScan;
        for (offset2 = start2; offset2 > 0 && count2 > 0; --offset2, --count2) {
            if (!this.boundaryChars.contains(Character.valueOf(buffer.charAt(offset2 - 1)))) continue;
            return offset2;
        }
        if (offset2 == 0) {
            return 0;
        }
        return start2;
    }

    @Override
    public int findEndOffset(StringBuilder buffer, int start2) {
        if (start2 > buffer.length() || start2 < 0) {
            return start2;
        }
        int count2 = this.maxScan;
        for (int offset2 = start2; offset2 < buffer.length() && count2 > 0; ++offset2, --count2) {
            if (!this.boundaryChars.contains(Character.valueOf(buffer.charAt(offset2)))) continue;
            return offset2;
        }
        return start2;
    }
}

