/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FieldTermStack;

public class FieldPhraseList {
    LinkedList<WeightedPhraseInfo> phraseList = new LinkedList();

    public FieldPhraseList(FieldTermStack fieldTermStack, FieldQuery fieldQuery) {
        this(fieldTermStack, fieldQuery, Integer.MAX_VALUE);
    }

    public FieldPhraseList(FieldTermStack fieldTermStack, FieldQuery fieldQuery, int phraseLimit) {
        String field2 = fieldTermStack.getFieldName();
        LinkedList<FieldTermStack.TermInfo> phraseCandidate = new LinkedList<FieldTermStack.TermInfo>();
        FieldQuery.QueryPhraseMap currMap = null;
        FieldQuery.QueryPhraseMap nextMap = null;
        block0: while (!fieldTermStack.isEmpty() && this.phraseList.size() < phraseLimit) {
            phraseCandidate.clear();
            FieldTermStack.TermInfo ti = fieldTermStack.pop();
            currMap = fieldQuery.getFieldTermMap(field2, ti.getText());
            if (currMap == null) continue;
            phraseCandidate.add(ti);
            while (true) {
                ti = fieldTermStack.pop();
                nextMap = null;
                if (ti != null) {
                    nextMap = currMap.getTermMap(ti.getText());
                }
                if (ti == null || nextMap == null) {
                    if (ti != null) {
                        fieldTermStack.push(ti);
                    }
                    if (currMap.isValidTermOrPhrase(phraseCandidate)) {
                        this.addIfNoOverlap(new WeightedPhraseInfo(phraseCandidate, currMap.getBoost(), currMap.getTermOrPhraseNumber()));
                        continue block0;
                    }
                    while (phraseCandidate.size() > 1) {
                        fieldTermStack.push(phraseCandidate.removeLast());
                        currMap = fieldQuery.searchPhrase(field2, phraseCandidate);
                        if (currMap == null) continue;
                        this.addIfNoOverlap(new WeightedPhraseInfo(phraseCandidate, currMap.getBoost(), currMap.getTermOrPhraseNumber()));
                        continue block0;
                    }
                    continue block0;
                }
                phraseCandidate.add(ti);
                currMap = nextMap;
            }
        }
    }

    void addIfNoOverlap(WeightedPhraseInfo wpi) {
        for (WeightedPhraseInfo existWpi : this.phraseList) {
            if (!existWpi.isOffsetOverlap(wpi)) continue;
            return;
        }
        this.phraseList.add(wpi);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeightedPhraseInfo {
        String text;
        List<Toffs> termsOffsets;
        float boost;
        int seqnum;

        public WeightedPhraseInfo(LinkedList<FieldTermStack.TermInfo> terms, float boost) {
            this(terms, boost, 0);
        }

        public WeightedPhraseInfo(LinkedList<FieldTermStack.TermInfo> terms, float boost, int number) {
            this.boost = boost;
            this.seqnum = number;
            this.termsOffsets = new ArrayList<Toffs>(terms.size());
            FieldTermStack.TermInfo ti = terms.get(0);
            this.termsOffsets.add(new Toffs(ti.getStartOffset(), ti.getEndOffset()));
            if (terms.size() == 1) {
                this.text = ti.getText();
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(ti.getText());
            int pos2 = ti.getPosition();
            for (int i2 = 1; i2 < terms.size(); ++i2) {
                ti = terms.get(i2);
                sb.append(ti.getText());
                if (ti.getPosition() - pos2 == 1) {
                    Toffs to = this.termsOffsets.get(this.termsOffsets.size() - 1);
                    to.setEndOffset(ti.getEndOffset());
                } else {
                    this.termsOffsets.add(new Toffs(ti.getStartOffset(), ti.getEndOffset()));
                }
                pos2 = ti.getPosition();
            }
            this.text = sb.toString();
        }

        public int getStartOffset() {
            return this.termsOffsets.get((int)0).startOffset;
        }

        public int getEndOffset() {
            return this.termsOffsets.get((int)(this.termsOffsets.size() - 1)).endOffset;
        }

        public boolean isOffsetOverlap(WeightedPhraseInfo other) {
            int so = this.getStartOffset();
            int eo = this.getEndOffset();
            int oso = other.getStartOffset();
            int oeo = other.getEndOffset();
            if (so <= oso && oso < eo) {
                return true;
            }
            if (so < oeo && oeo <= eo) {
                return true;
            }
            if (oso <= so && so < oeo) {
                return true;
            }
            return oso < eo && eo <= oeo;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.text).append('(').append(this.boost).append(")(");
            for (Toffs to : this.termsOffsets) {
                sb.append(to);
            }
            sb.append(')');
            return sb.toString();
        }

        public static class Toffs {
            int startOffset;
            int endOffset;

            public Toffs(int startOffset, int endOffset) {
                this.startOffset = startOffset;
                this.endOffset = endOffset;
            }

            public void setEndOffset(int endOffset) {
                this.endOffset = endOffset;
            }

            public int getStartOffset() {
                return this.startOffset;
            }

            public int getEndOffset() {
                return this.endOffset;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append('(').append(this.startOffset).append(',').append(this.endOffset).append(')');
                return sb.toString();
            }
        }
    }
}

