/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.NearSpansOrdered;
import org.apache.lucene.search.spans.NearSpansUnordered;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanNearQuery
extends SpanQuery
implements Cloneable {
    protected List<SpanQuery> clauses;
    protected int slop;
    protected boolean inOrder;
    protected String field;
    private boolean collectPayloads;

    public SpanNearQuery(SpanQuery[] clauses, int slop, boolean inOrder) {
        this(clauses, slop, inOrder, true);
    }

    public SpanNearQuery(SpanQuery[] clauses, int slop, boolean inOrder, boolean collectPayloads) {
        this.clauses = new ArrayList<SpanQuery>(clauses.length);
        for (int i2 = 0; i2 < clauses.length; ++i2) {
            SpanQuery clause = clauses[i2];
            if (i2 == 0) {
                this.field = clause.getField();
            } else if (!clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
        }
        this.collectPayloads = collectPayloads;
        this.slop = slop;
        this.inOrder = inOrder;
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        for (SpanQuery clause : this.clauses) {
            clause.extractTerms(terms);
        }
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanNear([");
        Iterator<SpanQuery> i2 = this.clauses.iterator();
        while (i2.hasNext()) {
            SpanQuery clause = i2.next();
            buffer.append(clause.toString(field2));
            if (!i2.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("], ");
        buffer.append(this.slop);
        buffer.append(", ");
        buffer.append(this.inOrder);
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public Spans getSpans(IndexReader reader) throws IOException {
        if (this.clauses.size() == 0) {
            return new SpanOrQuery(this.getClauses()).getSpans(reader);
        }
        if (this.clauses.size() == 1) {
            return this.clauses.get(0).getSpans(reader);
        }
        return this.inOrder ? new NearSpansOrdered(this, reader, this.collectPayloads) : new NearSpansUnordered(this, reader);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanNearQuery clone = null;
        for (int i2 = 0; i2 < this.clauses.size(); ++i2) {
            SpanQuery c = this.clauses.get(i2);
            SpanQuery query = (SpanQuery)c.rewrite(reader);
            if (query == c) continue;
            if (clone == null) {
                clone = (SpanNearQuery)this.clone();
            }
            clone.clauses.set(i2, query);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public Object clone() {
        int sz = this.clauses.size();
        SpanQuery[] newClauses = new SpanQuery[sz];
        for (int i2 = 0; i2 < sz; ++i2) {
            newClauses[i2] = (SpanQuery)this.clauses.get(i2).clone();
        }
        SpanNearQuery spanNearQuery = new SpanNearQuery(newClauses, this.slop, this.inOrder);
        spanNearQuery.setBoost(this.getBoost());
        return spanNearQuery;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanNearQuery)) {
            return false;
        }
        SpanNearQuery spanNearQuery = (SpanNearQuery)o;
        if (this.inOrder != spanNearQuery.inOrder) {
            return false;
        }
        if (this.slop != spanNearQuery.slop) {
            return false;
        }
        if (!((Object)this.clauses).equals(spanNearQuery.clauses)) {
            return false;
        }
        return this.getBoost() == spanNearQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int result2 = ((Object)this.clauses).hashCode();
        result2 ^= result2 << 14 | result2 >>> 19;
        result2 += Float.floatToRawIntBits(this.getBoost());
        result2 += this.slop;
        return result2 ^= this.inOrder ? -1716530243 : 0;
    }
}

