/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.search.highlight.TokenStreamFromTermPositionVector;
import org.apache.lucene.util.ArrayUtil;

public class TokenSources {
    public static TokenStream getAnyTokenStream(IndexReader reader, int docId, String field2, Document doc, Analyzer analyzer) throws IOException {
        TokenStream ts = null;
        TermFreqVector tfv = reader.getTermFreqVector(docId, field2);
        if (tfv != null && tfv instanceof TermPositionVector) {
            ts = TokenSources.getTokenStream((TermPositionVector)tfv);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(doc, field2, analyzer);
        }
        return ts;
    }

    public static TokenStream getAnyTokenStream(IndexReader reader, int docId, String field2, Analyzer analyzer) throws IOException {
        TokenStream ts = null;
        TermFreqVector tfv = reader.getTermFreqVector(docId, field2);
        if (tfv != null && tfv instanceof TermPositionVector) {
            ts = TokenSources.getTokenStream((TermPositionVector)tfv);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(reader, docId, field2, analyzer);
        }
        return ts;
    }

    public static TokenStream getTokenStream(TermPositionVector tpv) {
        return TokenSources.getTokenStream(tpv, false);
    }

    public static TokenStream getTokenStream(TermPositionVector tpv, boolean tokenPositionsGuaranteedContiguous) {
        if (!tokenPositionsGuaranteedContiguous && tpv.getTermPositions(0) != null) {
            return new TokenStreamFromTermPositionVector(tpv);
        }
        String[] terms = tpv.getTerms();
        int[] freq = tpv.getTermFrequencies();
        int totalTokens = 0;
        for (int t = 0; t < freq.length; ++t) {
            totalTokens += freq[t];
        }
        Token[] tokensInOriginalOrder = new Token[totalTokens];
        ArrayList<Token> unsortedTokens = null;
        for (int t = 0; t < freq.length; ++t) {
            Token token;
            int tp;
            TermVectorOffsetInfo[] offsets2 = tpv.getOffsets(t);
            if (offsets2 == null) {
                throw new IllegalArgumentException("Required TermVector Offset information was not found");
            }
            int[] pos2 = null;
            if (tokenPositionsGuaranteedContiguous) {
                pos2 = tpv.getTermPositions(t);
            }
            if (pos2 == null) {
                if (unsortedTokens == null) {
                    unsortedTokens = new ArrayList<Token>();
                }
                for (tp = 0; tp < offsets2.length; ++tp) {
                    token = new Token(terms[t], offsets2[tp].getStartOffset(), offsets2[tp].getEndOffset());
                    unsortedTokens.add(token);
                }
                continue;
            }
            for (tp = 0; tp < pos2.length; ++tp) {
                tokensInOriginalOrder[pos2[tp]] = token = new Token(terms[t], offsets2[tp].getStartOffset(), offsets2[tp].getEndOffset());
            }
        }
        if (unsortedTokens != null) {
            tokensInOriginalOrder = unsortedTokens.toArray(new Token[unsortedTokens.size()]);
            ArrayUtil.mergeSort(tokensInOriginalOrder, new Comparator<Token>(){

                @Override
                public int compare(Token t1, Token t2) {
                    if (t1.startOffset() == t2.startOffset()) {
                        return t1.endOffset() - t2.endOffset();
                    }
                    return t1.startOffset() - t2.startOffset();
                }
            });
        }
        final class StoredTokenStream
        extends TokenStream {
            Token[] tokens;
            int currentToken = 0;
            CharTermAttribute termAtt;
            OffsetAttribute offsetAtt;
            PositionIncrementAttribute posincAtt;

            StoredTokenStream(Token[] tokens) {
                this.tokens = tokens;
                this.termAtt = this.addAttribute(CharTermAttribute.class);
                this.offsetAtt = this.addAttribute(OffsetAttribute.class);
                this.posincAtt = this.addAttribute(PositionIncrementAttribute.class);
            }

            public boolean incrementToken() throws IOException {
                if (this.currentToken >= this.tokens.length) {
                    return false;
                }
                Token token = this.tokens[this.currentToken++];
                this.clearAttributes();
                this.termAtt.setEmpty().append(token);
                this.offsetAtt.setOffset(token.startOffset(), token.endOffset());
                this.posincAtt.setPositionIncrement(this.currentToken <= 1 || this.tokens[this.currentToken - 1].startOffset() > this.tokens[this.currentToken - 2].startOffset() ? 1 : 0);
                return true;
            }
        }
        return new StoredTokenStream(tokensInOriginalOrder);
    }

    public static TokenStream getTokenStream(IndexReader reader, int docId, String field2) throws IOException {
        TermFreqVector tfv = reader.getTermFreqVector(docId, field2);
        if (tfv == null) {
            throw new IllegalArgumentException(field2 + " in doc #" + docId + "does not have any term position data stored");
        }
        if (tfv instanceof TermPositionVector) {
            TermPositionVector tpv = (TermPositionVector)reader.getTermFreqVector(docId, field2);
            return TokenSources.getTokenStream(tpv);
        }
        throw new IllegalArgumentException(field2 + " in doc #" + docId + "does not have any term position data stored");
    }

    public static TokenStream getTokenStream(IndexReader reader, int docId, String field2, Analyzer analyzer) throws IOException {
        Document doc = reader.document(docId);
        return TokenSources.getTokenStream(doc, field2, analyzer);
    }

    public static TokenStream getTokenStream(Document doc, String field2, Analyzer analyzer) {
        String contents = doc.get(field2);
        if (contents == null) {
            throw new IllegalArgumentException("Field " + field2 + " in document is not stored and cannot be analyzed");
        }
        return TokenSources.getTokenStream(field2, contents, analyzer);
    }

    public static TokenStream getTokenStream(String field2, String contents, Analyzer analyzer) {
        try {
            return analyzer.reusableTokenStream(field2, new StringReader(contents));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

