/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixTermEnum;
import org.apache.lucene.search.SingleTermEnum;
import org.apache.lucene.search.WildcardTermEnum;
import org.apache.lucene.util.ToStringUtils;

public class WildcardQuery
extends MultiTermQuery {
    private boolean termContainsWildcard;
    private boolean termIsPrefix;
    protected Term term;

    public WildcardQuery(Term term) {
        this.term = term;
        String text = term.text();
        this.termContainsWildcard = text.indexOf(42) != -1 || text.indexOf(63) != -1;
        this.termIsPrefix = this.termContainsWildcard && text.indexOf(63) == -1 && text.indexOf(42) == text.length() - 1;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        if (this.termIsPrefix) {
            return new PrefixTermEnum(reader, this.term.createTerm(this.term.text().substring(0, this.term.text().indexOf(42))));
        }
        if (this.termContainsWildcard) {
            return new WildcardTermEnum(reader, this.getTerm());
        }
        return new SingleTermEnum(reader, this.getTerm());
    }

    public Term getTerm() {
        return this.term;
    }

    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field2)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.term == null ? 0 : this.term.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardQuery other = (WildcardQuery)obj;
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }
}

