/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TopDocsCollector<T extends ScoreDoc>
extends Collector {
    protected static final TopDocs EMPTY_TOPDOCS = new TopDocs(0, new ScoreDoc[0], Float.NaN);
    protected PriorityQueue<T> pq;
    protected int totalHits;

    protected TopDocsCollector(PriorityQueue<T> pq) {
        this.pq = pq;
    }

    protected void populateResults(ScoreDoc[] results, int howMany) {
        for (int i2 = howMany - 1; i2 >= 0; --i2) {
            results[i2] = (ScoreDoc)this.pq.pop();
        }
    }

    protected TopDocs newTopDocs(ScoreDoc[] results, int start2) {
        return results == null ? EMPTY_TOPDOCS : new TopDocs(this.totalHits, results);
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    protected int topDocsSize() {
        return this.totalHits < this.pq.size() ? this.totalHits : this.pq.size();
    }

    public TopDocs topDocs() {
        return this.topDocs(0, this.topDocsSize());
    }

    public TopDocs topDocs(int start2) {
        return this.topDocs(start2, this.topDocsSize());
    }

    public TopDocs topDocs(int start2, int howMany) {
        int size2 = this.topDocsSize();
        if (start2 < 0 || start2 >= size2 || howMany <= 0) {
            return this.newTopDocs(null, start2);
        }
        howMany = Math.min(size2 - start2, howMany);
        ScoreDoc[] results = new ScoreDoc[howMany];
        for (int i2 = this.pq.size() - start2 - howMany; i2 > 0; --i2) {
            this.pq.pop();
        }
        this.populateResults(results, howMany);
        return this.newTopDocs(results, start2);
    }
}

