/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DisjunctionMaxScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisjunctionMaxQuery
extends Query
implements Iterable<Query> {
    private ArrayList<Query> disjuncts = new ArrayList();
    private float tieBreakerMultiplier = 0.0f;

    public DisjunctionMaxQuery(float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    public DisjunctionMaxQuery(Collection<Query> disjuncts, float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.add(disjuncts);
    }

    public void add(Query query) {
        this.disjuncts.add(query);
    }

    public void add(Collection<Query> disjuncts) {
        this.disjuncts.addAll(disjuncts);
    }

    @Override
    public Iterator<Query> iterator() {
        return this.disjuncts.iterator();
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new DisjunctionMaxWeight(searcher);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        int numDisjunctions = this.disjuncts.size();
        if (numDisjunctions == 1) {
            Query singleton = this.disjuncts.get(0);
            Query result2 = singleton.rewrite(reader);
            if (this.getBoost() != 1.0f) {
                if (result2 == singleton) {
                    result2 = (Query)result2.clone();
                }
                result2.setBoost(this.getBoost() * result2.getBoost());
            }
            return result2;
        }
        DisjunctionMaxQuery clone = null;
        for (int i2 = 0; i2 < numDisjunctions; ++i2) {
            Query clause = this.disjuncts.get(i2);
            Query rewrite = clause.rewrite(reader);
            if (rewrite == clause) continue;
            if (clone == null) {
                clone = (DisjunctionMaxQuery)this.clone();
            }
            clone.disjuncts.set(i2, rewrite);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public Object clone() {
        DisjunctionMaxQuery clone = (DisjunctionMaxQuery)super.clone();
        clone.disjuncts = (ArrayList)this.disjuncts.clone();
        return clone;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        for (Query query : this.disjuncts) {
            query.extractTerms(terms);
        }
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        int numDisjunctions = this.disjuncts.size();
        for (int i2 = 0; i2 < numDisjunctions; ++i2) {
            Query subquery = this.disjuncts.get(i2);
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field2));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field2));
            }
            if (i2 == numDisjunctions - 1) continue;
            buffer.append(" | ");
        }
        buffer.append(")");
        if (this.tieBreakerMultiplier != 0.0f) {
            buffer.append("~");
            buffer.append(this.tieBreakerMultiplier);
        }
        if ((double)this.getBoost() != 1.0) {
            buffer.append("^");
            buffer.append(this.getBoost());
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DisjunctionMaxQuery)) {
            return false;
        }
        DisjunctionMaxQuery other = (DisjunctionMaxQuery)o;
        return this.getBoost() == other.getBoost() && this.tieBreakerMultiplier == other.tieBreakerMultiplier && this.disjuncts.equals(other.disjuncts);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) + Float.floatToIntBits(this.tieBreakerMultiplier) + this.disjuncts.hashCode();
    }

    protected class DisjunctionMaxWeight
    extends Weight {
        protected Similarity similarity;
        protected ArrayList<Weight> weights = new ArrayList();

        public DisjunctionMaxWeight(Searcher searcher) throws IOException {
            this.similarity = searcher.getSimilarity();
            for (Query disjunctQuery : DisjunctionMaxQuery.this.disjuncts) {
                this.weights.add(disjunctQuery.createWeight(searcher));
            }
        }

        public Query getQuery() {
            return DisjunctionMaxQuery.this;
        }

        public float getValue() {
            return DisjunctionMaxQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float max2 = 0.0f;
            float sum2 = 0.0f;
            for (Weight currentWeight : this.weights) {
                float sub3 = currentWeight.sumOfSquaredWeights();
                sum2 += sub3;
                max2 = Math.max(max2, sub3);
            }
            float boost = DisjunctionMaxQuery.this.getBoost();
            return ((sum2 - max2) * DisjunctionMaxQuery.this.tieBreakerMultiplier * DisjunctionMaxQuery.this.tieBreakerMultiplier + max2) * boost * boost;
        }

        public void normalize(float norm) {
            norm *= DisjunctionMaxQuery.this.getBoost();
            for (Weight wt : this.weights) {
                wt.normalize(norm);
            }
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer[] scorers = new Scorer[this.weights.size()];
            int idx = 0;
            for (Weight w : this.weights) {
                Scorer subScorer = w.scorer(reader, true, false);
                if (subScorer == null) continue;
                scorers[idx++] = subScorer;
            }
            if (idx == 0) {
                return null;
            }
            DisjunctionMaxScorer result2 = new DisjunctionMaxScorer(this, DisjunctionMaxQuery.this.tieBreakerMultiplier, this.similarity, scorers, idx);
            return result2;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            if (DisjunctionMaxQuery.this.disjuncts.size() == 1) {
                return this.weights.get(0).explain(reader, doc);
            }
            ComplexExplanation result2 = new ComplexExplanation();
            float max2 = 0.0f;
            float sum2 = 0.0f;
            result2.setDescription(DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:");
            for (Weight wt : this.weights) {
                Explanation e = wt.explain(reader, doc);
                if (!e.isMatch()) continue;
                result2.setMatch(Boolean.TRUE);
                result2.addDetail(e);
                sum2 += e.getValue();
                max2 = Math.max(max2, e.getValue());
            }
            result2.setValue(max2 + (sum2 - max2) * DisjunctionMaxQuery.this.tieBreakerMultiplier);
            return result2;
        }
    }
}

