/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFieldQueryParser
extends QueryParser {
    protected String[] fields;
    protected Map<String, Float> boosts;

    public MultiFieldQueryParser(Version matchVersion, String[] fields2, Analyzer analyzer, Map<String, Float> boosts) {
        this(matchVersion, fields2, analyzer);
        this.boosts = boosts;
    }

    public MultiFieldQueryParser(Version matchVersion, String[] fields2, Analyzer analyzer) {
        super(matchVersion, null, analyzer);
        this.fields = fields2;
    }

    @Override
    protected Query getFieldQuery(String field2, String queryText, int slop) throws ParseException {
        if (field2 == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                Float boost;
                Query q = super.getFieldQuery(this.fields[i2], queryText, true);
                if (q == null) continue;
                if (this.boosts != null && (boost = this.boosts.get(this.fields[i2])) != null) {
                    q.setBoost(boost.floatValue());
                }
                this.applySlop(q, slop);
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        Query q = super.getFieldQuery(field2, queryText, true);
        this.applySlop(q, slop);
        return q;
    }

    private void applySlop(Query q, int slop) {
        if (q instanceof PhraseQuery) {
            ((PhraseQuery)q).setSlop(slop);
        } else if (q instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)q).setSlop(slop);
        }
    }

    @Override
    protected Query getFieldQuery(String field2, String queryText, boolean quoted) throws ParseException {
        if (field2 == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                Float boost;
                Query q = super.getFieldQuery(this.fields[i2], queryText, quoted);
                if (q == null) continue;
                if (this.boosts != null && (boost = this.boosts.get(this.fields[i2])) != null) {
                    q.setBoost(boost.floatValue());
                }
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        Query q = super.getFieldQuery(field2, queryText, quoted);
        return q;
    }

    @Override
    protected Query getFuzzyQuery(String field2, String termStr, float minSimilarity) throws ParseException {
        if (field2 == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                clauses.add(new BooleanClause(this.getFuzzyQuery(this.fields[i2], termStr, minSimilarity), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getFuzzyQuery(field2, termStr, minSimilarity);
    }

    @Override
    protected Query getPrefixQuery(String field2, String termStr) throws ParseException {
        if (field2 == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                clauses.add(new BooleanClause(this.getPrefixQuery(this.fields[i2], termStr), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getPrefixQuery(field2, termStr);
    }

    @Override
    protected Query getWildcardQuery(String field2, String termStr) throws ParseException {
        if (field2 == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                clauses.add(new BooleanClause(this.getWildcardQuery(this.fields[i2], termStr), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getWildcardQuery(field2, termStr);
    }

    @Override
    protected Query getRangeQuery(String field2, String part1, String part2, boolean inclusive) throws ParseException {
        if (field2 == null) {
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                clauses.add(new BooleanClause(this.getRangeQuery(this.fields[i2], part1, part2, inclusive), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getRangeQuery(field2, part1, part2, inclusive);
    }

    public static Query parse(Version matchVersion, String[] queries, String[] fields2, Analyzer analyzer) throws ParseException {
        if (queries.length != fields2.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        for (int i2 = 0; i2 < fields2.length; ++i2) {
            QueryParser qp = new QueryParser(matchVersion, fields2[i2], analyzer);
            Query q = qp.parse(queries[i2]);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).getClauses().length <= 0) continue;
            bQuery.add(q, BooleanClause.Occur.SHOULD);
        }
        return bQuery;
    }

    public static Query parse(Version matchVersion, String query, String[] fields2, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (fields2.length != flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        for (int i2 = 0; i2 < fields2.length; ++i2) {
            QueryParser qp = new QueryParser(matchVersion, fields2[i2], analyzer);
            Query q = qp.parse(query);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).getClauses().length <= 0) continue;
            bQuery.add(q, flags[i2]);
        }
        return bQuery;
    }

    public static Query parse(Version matchVersion, String[] queries, String[] fields2, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (queries.length != fields2.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        for (int i2 = 0; i2 < fields2.length; ++i2) {
            QueryParser qp = new QueryParser(matchVersion, fields2[i2], analyzer);
            Query q = qp.parse(queries[i2]);
            if (q == null || q instanceof BooleanQuery && ((BooleanQuery)q).getClauses().length <= 0) continue;
            bQuery.add(q, flags[i2]);
        }
        return bQuery;
    }
}

