/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryIndex
implements Serializable {
    private final HashMap<String, Info> fields = new HashMap();
    private transient Map.Entry<String, Info>[] sortedFields;
    private final int stride;
    private static final float docBoost = 1.0f;
    private static final long serialVersionUID = 2782195016849084649L;
    private static final boolean DEBUG = false;
    private final FieldInfos fieldInfos;
    private static final Comparator<Object> termComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Map.Entry) {
                o1 = ((Map.Entry)o1).getKey();
            }
            if (o2 instanceof Map.Entry) {
                o2 = ((Map.Entry)o2).getKey();
            }
            if (o1 == o2) {
                return 0;
            }
            return ((String)o1).compareTo((String)o2);
        }
    };
    private static final Term MATCH_ALL_TERM = new Term("");

    public MemoryIndex() {
        this(false);
    }

    private MemoryIndex(boolean storeOffsets) {
        this.stride = storeOffsets ? 3 : 1;
        this.fieldInfos = new FieldInfos();
    }

    public void addField(String fieldName, String text, Analyzer analyzer) {
        TokenStream stream;
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (analyzer == null) {
            throw new IllegalArgumentException("analyzer must not be null");
        }
        try {
            stream = analyzer.reusableTokenStream(fieldName, new StringReader(text));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.addField(fieldName, stream);
    }

    public <T> TokenStream keywordTokenStream(final Collection<T> keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException("keywords must not be null");
        }
        return new TokenStream(){
            private Iterator<T> iter;
            private int start;
            private final CharTermAttribute termAtt;
            private final OffsetAttribute offsetAtt;
            {
                this.iter = keywords.iterator();
                this.start = 0;
                this.termAtt = this.addAttribute(CharTermAttribute.class);
                this.offsetAtt = this.addAttribute(OffsetAttribute.class);
            }

            public boolean incrementToken() {
                if (!this.iter.hasNext()) {
                    return false;
                }
                Object obj = this.iter.next();
                if (obj == null) {
                    throw new IllegalArgumentException("keyword must not be null");
                }
                String term = obj.toString();
                this.clearAttributes();
                this.termAtt.setEmpty().append(term);
                this.offsetAtt.setOffset(this.start, this.start + this.termAtt.length());
                this.start += term.length() + 1;
                return true;
            }
        };
    }

    public void addField(String fieldName, TokenStream stream) {
        this.addField(fieldName, stream, 1.0f);
    }

    public void addField(String fieldName, TokenStream stream, float boost) {
        try {
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName must not be null");
            }
            if (stream == null) {
                throw new IllegalArgumentException("token stream must not be null");
            }
            if (boost <= 0.0f) {
                throw new IllegalArgumentException("boost factor must be greater than 0.0");
            }
            if (this.fields.get(fieldName) != null) {
                throw new IllegalArgumentException("field must not be added more than once");
            }
            HashMap<String, ArrayIntList> terms = new HashMap<String, ArrayIntList>();
            int numTokens = 0;
            int numOverlapTokens = 0;
            int pos2 = -1;
            this.fieldInfos.add(fieldName, true, true);
            CharTermAttribute termAtt = stream.addAttribute(CharTermAttribute.class);
            PositionIncrementAttribute posIncrAttribute = stream.addAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offsetAtt = stream.addAttribute(OffsetAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                String term = termAtt.toString();
                if (term.length() == 0) continue;
                ++numTokens;
                int posIncr = posIncrAttribute.getPositionIncrement();
                if (posIncr == 0) {
                    ++numOverlapTokens;
                }
                pos2 += posIncr;
                ArrayIntList positions = terms.get(term);
                if (positions == null) {
                    positions = new ArrayIntList(this.stride);
                    terms.put(term, positions);
                }
                if (this.stride == 1) {
                    positions.add(pos2);
                    continue;
                }
                positions.add(pos2, offsetAtt.startOffset(), offsetAtt.endOffset());
            }
            stream.end();
            if (numTokens > 0) {
                this.fields.put(fieldName, new Info(terms, numTokens, numOverlapTokens, boost *= 1.0f));
                this.sortedFields = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public IndexSearcher createSearcher() {
        MemoryIndexReader reader = new MemoryIndexReader();
        IndexSearcher searcher = new IndexSearcher(reader);
        reader.setSearcher(searcher);
        return searcher;
    }

    public float search(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        IndexSearcher searcher = this.createSearcher();
        try {
            float score;
            final float[] scores = new float[1];
            ((Searcher)searcher).search(query, new Collector(){
                private Scorer scorer;

                public void collect(int doc) throws IOException {
                    scores[0] = this.scorer.score();
                }

                public void setScorer(Scorer scorer) throws IOException {
                    this.scorer = scorer;
                }

                public boolean acceptsDocsOutOfOrder() {
                    return true;
                }

                public void setNextReader(IndexReader reader, int docBase) {
                }
            });
            float f = score = scores[0];
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getMemorySize() {
        return RamUsageEstimator.sizeOf(this);
    }

    private int numPositions(ArrayIntList positions) {
        return positions.size() / this.stride;
    }

    private void sortFields() {
        if (this.sortedFields == null) {
            this.sortedFields = MemoryIndex.sort(this.fields);
        }
    }

    private static <K, V> Map.Entry<K, V>[] sort(HashMap<K, V> map) {
        int size2 = map.size();
        Map.Entry[] entries2 = new Map.Entry[size2];
        Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
        for (int i2 = 0; i2 < size2; ++i2) {
            entries2[i2] = iter.next();
        }
        if (size2 > 1) {
            ArrayUtil.quickSort(entries2, termComparator);
        }
        return entries2;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder(256);
        this.sortFields();
        int sumPositions = 0;
        int sumTerms = 0;
        for (int i2 = 0; i2 < this.sortedFields.length; ++i2) {
            Map.Entry<String, Info> entry = this.sortedFields[i2];
            String fieldName = entry.getKey();
            Info info = entry.getValue();
            info.sortTerms();
            result2.append(fieldName + ":\n");
            int numPositions = 0;
            for (int j = 0; j < info.sortedTerms.length; ++j) {
                Map.Entry e = info.sortedTerms[j];
                String term = (String)e.getKey();
                ArrayIntList positions = (ArrayIntList)e.getValue();
                result2.append("\t'" + term + "':" + this.numPositions(positions) + ":");
                result2.append(positions.toString(this.stride));
                result2.append("\n");
                numPositions += this.numPositions(positions);
            }
            result2.append("\tterms=" + info.sortedTerms.length);
            result2.append(", positions=" + numPositions);
            result2.append(", memory=" + RamUsageEstimator.humanReadableUnits(RamUsageEstimator.sizeOf(info)));
            result2.append("\n");
            sumPositions += numPositions;
            sumTerms += info.sortedTerms.length;
        }
        result2.append("\nfields=" + this.sortedFields.length);
        result2.append(", terms=" + sumTerms);
        result2.append(", positions=" + sumPositions);
        result2.append(", memory=" + RamUsageEstimator.humanReadableUnits(this.getMemorySize()));
        return result2.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MemoryIndexReader
    extends IndexReader {
        private Searcher searcher;
        private byte[] cachedNorms;
        private String cachedFieldName;
        private Similarity cachedSimilarity;

        private MemoryIndexReader() {
        }

        private Info getInfo(String fieldName) {
            return (Info)MemoryIndex.this.fields.get(fieldName);
        }

        private Info getInfo(int pos2) {
            return (Info)MemoryIndex.this.sortedFields[pos2].getValue();
        }

        @Override
        public FieldInfos getFieldInfos() {
            return MemoryIndex.this.fieldInfos;
        }

        @Override
        public int docFreq(Term term) {
            Info info = this.getInfo(term.field());
            int freq = 0;
            if (info != null) {
                freq = info.getPositions(term.text()) != null ? 1 : 0;
            }
            return freq;
        }

        @Override
        public TermEnum terms() {
            return this.terms(MATCH_ALL_TERM);
        }

        @Override
        public TermEnum terms(Term term) {
            int i2;
            MemoryIndex.this.sortFields();
            int j = MemoryIndex.this.sortedFields.length == 1 && MemoryIndex.this.sortedFields[0].getKey() == term.field() ? 0 : Arrays.binarySearch(MemoryIndex.this.sortedFields, term.field(), termComparator);
            if (j < 0) {
                j = -j - 1;
                i2 = 0;
                if (j < MemoryIndex.this.sortedFields.length) {
                    this.getInfo(j).sortTerms();
                }
            } else {
                Info info = this.getInfo(j);
                info.sortTerms();
                i2 = Arrays.binarySearch(info.sortedTerms, term.text(), termComparator);
                if (i2 < 0 && (i2 = -i2 - 1) >= info.sortedTerms.length) {
                    i2 = 0;
                    if (++j < MemoryIndex.this.sortedFields.length) {
                        this.getInfo(j).sortTerms();
                    }
                }
            }
            final int ix = i2;
            final int jx = j;
            return new TermEnum(){
                private int srtTermsIdx;
                private int srtFldsIdx;
                {
                    this.srtTermsIdx = ix;
                    this.srtFldsIdx = jx;
                }

                public boolean next() {
                    if (this.srtFldsIdx >= MemoryIndex.this.sortedFields.length) {
                        return false;
                    }
                    Info info = MemoryIndexReader.this.getInfo(this.srtFldsIdx);
                    if (++this.srtTermsIdx < info.sortedTerms.length) {
                        return true;
                    }
                    ++this.srtFldsIdx;
                    this.srtTermsIdx = 0;
                    if (this.srtFldsIdx >= MemoryIndex.this.sortedFields.length) {
                        return false;
                    }
                    MemoryIndexReader.this.getInfo(this.srtFldsIdx).sortTerms();
                    return true;
                }

                public Term term() {
                    if (this.srtFldsIdx >= MemoryIndex.this.sortedFields.length) {
                        return null;
                    }
                    Info info = MemoryIndexReader.this.getInfo(this.srtFldsIdx);
                    if (this.srtTermsIdx >= info.sortedTerms.length) {
                        return null;
                    }
                    return this.createTerm(info, this.srtFldsIdx, (String)info.sortedTerms[this.srtTermsIdx].getKey());
                }

                public int docFreq() {
                    if (this.srtFldsIdx >= MemoryIndex.this.sortedFields.length) {
                        return 0;
                    }
                    Info info = MemoryIndexReader.this.getInfo(this.srtFldsIdx);
                    if (this.srtTermsIdx >= info.sortedTerms.length) {
                        return 0;
                    }
                    return MemoryIndex.this.numPositions(info.getPositions(this.srtTermsIdx));
                }

                public void close() {
                }

                private Term createTerm(Info info, int pos2, String text) {
                    Term template = info.template;
                    if (template == null) {
                        String fieldName = (String)MemoryIndex.this.sortedFields[pos2].getKey();
                        info.template = template = new Term(fieldName);
                    }
                    return template.createTerm(text);
                }
            };
        }

        @Override
        public TermPositions termPositions() {
            return new TermPositions(){
                private boolean hasNext;
                private int cursor = 0;
                private ArrayIntList current;
                private Term term;

                public void seek(Term term) {
                    this.term = term;
                    if (term == null) {
                        this.hasNext = true;
                    } else {
                        Info info = MemoryIndexReader.this.getInfo(term.field());
                        this.current = info == null ? null : info.getPositions(term.text());
                        this.hasNext = this.current != null;
                        this.cursor = 0;
                    }
                }

                public void seek(TermEnum termEnum) {
                    this.seek(termEnum.term());
                }

                public int doc() {
                    return 0;
                }

                public int freq() {
                    int freq = this.current != null ? MemoryIndex.this.numPositions(this.current) : (this.term == null ? 1 : 0);
                    return freq;
                }

                public boolean next() {
                    boolean next = this.hasNext;
                    this.hasNext = false;
                    return next;
                }

                public int read(int[] docs, int[] freqs) {
                    if (!this.hasNext) {
                        return 0;
                    }
                    this.hasNext = false;
                    docs[0] = 0;
                    freqs[0] = this.freq();
                    return 1;
                }

                public boolean skipTo(int target) {
                    return this.next();
                }

                public void close() {
                }

                public int nextPosition() {
                    int pos2 = this.current.get(this.cursor);
                    this.cursor += MemoryIndex.this.stride;
                    return pos2;
                }

                public int getPayloadLength() {
                    throw new UnsupportedOperationException();
                }

                public byte[] getPayload(byte[] data2, int offset2) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public boolean isPayloadAvailable() {
                    return false;
                }
            };
        }

        @Override
        public TermDocs termDocs() {
            return this.termPositions();
        }

        @Override
        public TermFreqVector[] getTermFreqVectors(int docNumber) {
            TermFreqVector[] vectors = new TermFreqVector[MemoryIndex.this.fields.size()];
            Iterator iter = MemoryIndex.this.fields.keySet().iterator();
            for (int i2 = 0; i2 < vectors.length; ++i2) {
                vectors[i2] = this.getTermFreqVector(docNumber, (String)iter.next());
            }
            return vectors;
        }

        @Override
        public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
            for (String fieldName : MemoryIndex.this.fields.keySet()) {
                this.getTermFreqVector(docNumber, fieldName, mapper);
            }
        }

        @Override
        public void getTermFreqVector(int docNumber, String field2, TermVectorMapper mapper) throws IOException {
            Info info = this.getInfo(field2);
            if (info == null) {
                return;
            }
            info.sortTerms();
            mapper.setExpectations(field2, info.sortedTerms.length, MemoryIndex.this.stride != 1, true);
            int i2 = info.sortedTerms.length;
            while (--i2 >= 0) {
                ArrayIntList positions = (ArrayIntList)info.sortedTerms[i2].getValue();
                int size2 = positions.size();
                TermVectorOffsetInfo[] offsets2 = new TermVectorOffsetInfo[size2 / MemoryIndex.this.stride];
                int k = 0;
                for (int j = 1; j < size2; j += MemoryIndex.this.stride) {
                    int start2 = positions.get(j);
                    int end2 = positions.get(j + 1);
                    offsets2[k] = new TermVectorOffsetInfo(start2, end2);
                    ++k;
                }
                mapper.map((String)info.sortedTerms[i2].getKey(), MemoryIndex.this.numPositions((ArrayIntList)info.sortedTerms[i2].getValue()), offsets2, ((ArrayIntList)info.sortedTerms[i2].getValue()).toArray(MemoryIndex.this.stride));
            }
        }

        @Override
        public TermFreqVector getTermFreqVector(int docNumber, final String fieldName) {
            final Info info = this.getInfo(fieldName);
            if (info == null) {
                return null;
            }
            info.sortTerms();
            return new TermPositionVector(){
                private final Map.Entry<String, ArrayIntList>[] sortedTerms;
                {
                    this.sortedTerms = info.sortedTerms;
                }

                public String getField() {
                    return fieldName;
                }

                public int size() {
                    return this.sortedTerms.length;
                }

                public String[] getTerms() {
                    String[] terms = new String[this.sortedTerms.length];
                    int i2 = this.sortedTerms.length;
                    while (--i2 >= 0) {
                        terms[i2] = this.sortedTerms[i2].getKey();
                    }
                    return terms;
                }

                public int[] getTermFrequencies() {
                    int[] freqs = new int[this.sortedTerms.length];
                    int i2 = this.sortedTerms.length;
                    while (--i2 >= 0) {
                        freqs[i2] = MemoryIndex.this.numPositions(this.sortedTerms[i2].getValue());
                    }
                    return freqs;
                }

                public int indexOf(String term) {
                    int i2 = Arrays.binarySearch(this.sortedTerms, term, termComparator);
                    return i2 >= 0 ? i2 : -1;
                }

                public int[] indexesOf(String[] terms, int start2, int len) {
                    int[] indexes2 = new int[len];
                    for (int i2 = 0; i2 < len; ++i2) {
                        indexes2[i2] = this.indexOf(terms[start2++]);
                    }
                    return indexes2;
                }

                public int[] getTermPositions(int index2) {
                    return this.sortedTerms[index2].getValue().toArray(MemoryIndex.this.stride);
                }

                public TermVectorOffsetInfo[] getOffsets(int index2) {
                    if (MemoryIndex.this.stride == 1) {
                        return null;
                    }
                    ArrayIntList positions = this.sortedTerms[index2].getValue();
                    int size2 = positions.size();
                    TermVectorOffsetInfo[] offsets2 = new TermVectorOffsetInfo[size2 / MemoryIndex.this.stride];
                    int i2 = 0;
                    for (int j = 1; j < size2; j += MemoryIndex.this.stride) {
                        int start2 = positions.get(j);
                        int end2 = positions.get(j + 1);
                        offsets2[i2] = new TermVectorOffsetInfo(start2, end2);
                        ++i2;
                    }
                    return offsets2;
                }
            };
        }

        private Similarity getSimilarity() {
            if (this.searcher != null) {
                return this.searcher.getSimilarity();
            }
            return Similarity.getDefault();
        }

        private void setSearcher(Searcher searcher) {
            this.searcher = searcher;
        }

        @Override
        public byte[] norms(String fieldName) {
            byte[] norms = this.cachedNorms;
            Similarity sim = this.getSimilarity();
            if (fieldName != this.cachedFieldName || sim != this.cachedSimilarity) {
                Info info = this.getInfo(fieldName);
                int numTokens = info != null ? info.numTokens : 0;
                int numOverlapTokens = info != null ? info.numOverlapTokens : 0;
                float boost = info != null ? info.getBoost() : 1.0f;
                FieldInvertState invertState = new FieldInvertState(0, numTokens, numOverlapTokens, 0, boost);
                float n = sim.computeNorm(fieldName, invertState);
                byte norm = sim.encodeNormValue(n);
                this.cachedNorms = norms = new byte[]{norm};
                this.cachedFieldName = fieldName;
                this.cachedSimilarity = sim;
            }
            return norms;
        }

        @Override
        public void norms(String fieldName, byte[] bytes2, int offset2) {
            byte[] norms = this.norms(fieldName);
            System.arraycopy(norms, 0, bytes2, offset2, norms.length);
        }

        @Override
        @Deprecated
        protected void doSetNorm(int doc, String fieldName, byte value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int numDocs() {
            return MemoryIndex.this.fields.size() > 0 ? 1 : 0;
        }

        @Override
        public int maxDoc() {
            return 1;
        }

        @Override
        public Document document(int n, FieldSelector fieldSelector) throws IOException {
            return new Document();
        }

        @Override
        public boolean isDeleted(int n) {
            return false;
        }

        @Override
        public boolean hasDeletions() {
            return false;
        }

        @Override
        @Deprecated
        protected void doDelete(int docNum) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        protected void doUndeleteAll() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        protected void doCommit(Map<String, String> commitUserData) {
        }

        @Override
        protected void doClose() {
        }
    }

    private static final class ArrayIntList
    implements Serializable {
        private int[] elements;
        private int size = 0;
        private static final long serialVersionUID = 2282195016849084649L;

        public ArrayIntList(int initialCapacity) {
            this.elements = new int[initialCapacity];
        }

        public void add(int elem) {
            if (this.size == this.elements.length) {
                this.ensureCapacity(this.size + 1);
            }
            this.elements[this.size++] = elem;
        }

        public void add(int pos2, int start2, int end2) {
            if (this.size + 3 > this.elements.length) {
                this.ensureCapacity(this.size + 3);
            }
            this.elements[this.size] = pos2;
            this.elements[this.size + 1] = start2;
            this.elements[this.size + 2] = end2;
            this.size += 3;
        }

        public int get(int index2) {
            if (index2 >= this.size) {
                this.throwIndex(index2);
            }
            return this.elements[index2];
        }

        public int size() {
            return this.size;
        }

        public int[] toArray(int stride) {
            int[] arr = new int[this.size() / stride];
            if (stride == 1) {
                System.arraycopy(this.elements, 0, arr, 0, this.size);
            } else {
                int i2 = 0;
                for (int j = 0; j < this.size; j += stride) {
                    arr[i2] = this.elements[j];
                    ++i2;
                }
            }
            return arr;
        }

        private void ensureCapacity(int minCapacity) {
            int newCapacity = Math.max(minCapacity, this.elements.length * 3 / 2 + 1);
            int[] newElements = new int[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
            this.elements = newElements;
        }

        private void throwIndex(int index2) {
            throw new IndexOutOfBoundsException("index: " + index2 + ", size: " + this.size);
        }

        public String toString(int stride) {
            int s2 = this.size() / stride;
            int len = Math.min(10, s2);
            StringBuilder buf = new StringBuilder(4 * len);
            buf.append("[");
            for (int i2 = 0; i2 < len; ++i2) {
                buf.append(this.get(i2 * stride));
                if (i2 >= len - 1) continue;
                buf.append(", ");
            }
            if (len != s2) {
                buf.append(", ...");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Info
    implements Serializable {
        private final HashMap<String, ArrayIntList> terms;
        private transient Map.Entry<String, ArrayIntList>[] sortedTerms;
        private final int numTokens;
        private final int numOverlapTokens;
        private final float boost;
        public transient Term template;
        private static final long serialVersionUID = 2882195016849084649L;

        public Info(HashMap<String, ArrayIntList> terms, int numTokens, int numOverlapTokens, float boost) {
            this.terms = terms;
            this.numTokens = numTokens;
            this.numOverlapTokens = numOverlapTokens;
            this.boost = boost;
        }

        public void sortTerms() {
            if (this.sortedTerms == null) {
                this.sortedTerms = MemoryIndex.sort(this.terms);
            }
        }

        public ArrayIntList getPositions(String term) {
            return this.terms.get(term);
        }

        public ArrayIntList getPositions(int pos2) {
            return this.sortedTerms[pos2].getValue();
        }

        public float getBoost() {
            return this.boost;
        }
    }
}

