/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.ReadOnlyDirectoryReader;
import org.apache.lucene.index.ReadOnlySegmentReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StaleReaderException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectoryReader
extends IndexReader
implements Cloneable {
    protected Directory directory;
    protected boolean readOnly;
    IndexWriter writer;
    private IndexDeletionPolicy deletionPolicy;
    private Lock writeLock;
    private final SegmentInfos segmentInfos;
    private boolean stale;
    private final int termInfosIndexDivisor;
    private boolean rollbackHasChanges;
    private SegmentReader[] subReaders;
    private int[] starts;
    private Map<String, byte[]> normsCache = new HashMap<String, byte[]>();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;
    private long maxIndexVersion;
    private final boolean applyAllDeletes;

    static IndexReader open(Directory directory, final IndexDeletionPolicy deletionPolicy, IndexCommit commit, final boolean readOnly, final int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return (IndexReader)new SegmentInfos.FindSegmentsFile(directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.directory, segmentFileName);
                if (readOnly) {
                    return new ReadOnlyDirectoryReader(this.directory, infos, deletionPolicy, termInfosIndexDivisor);
                }
                return new DirectoryReader(this.directory, infos, deletionPolicy, false, termInfosIndexDivisor);
            }
        }.run(commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DirectoryReader(Directory directory, SegmentInfos sis, IndexDeletionPolicy deletionPolicy, boolean readOnly, int termInfosIndexDivisor) throws IOException {
        this.directory = directory;
        this.readOnly = readOnly;
        this.segmentInfos = sis;
        this.deletionPolicy = deletionPolicy;
        this.termInfosIndexDivisor = termInfosIndexDivisor;
        this.applyAllDeletes = false;
        Closeable[] readers = new SegmentReader[sis.size()];
        int i2 = sis.size() - 1;
        while (true) {
            block8: {
                Object var12_11;
                if (i2 < 0) {
                    this.initialize((SegmentReader[])readers);
                    return;
                }
                IOException prior = null;
                boolean success2 = false;
                try {
                    try {
                        readers[i2] = SegmentReader.get(readOnly, sis.info(i2), termInfosIndexDivisor);
                        success2 = true;
                    }
                    catch (IOException ex) {
                        prior = ex;
                        var12_11 = null;
                        if (!success2) {
                            IOUtils.closeWhileHandlingException(prior, readers);
                        }
                        break block8;
                    }
                    var12_11 = null;
                    if (success2) break block8;
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    if (!success2) {
                        IOUtils.closeWhileHandlingException(prior, readers);
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(prior, readers);
            }
            --i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DirectoryReader(IndexWriter writer, SegmentInfos infos, int termInfosIndexDivisor, boolean applyAllDeletes) throws IOException {
        this.directory = writer.getDirectory();
        this.readOnly = true;
        this.applyAllDeletes = applyAllDeletes;
        this.termInfosIndexDivisor = termInfosIndexDivisor;
        int numSegments = infos.size();
        ArrayList<SegmentReader> readers = new ArrayList<SegmentReader>();
        Directory dir = writer.getDirectory();
        this.segmentInfos = (SegmentInfos)infos.clone();
        int infosUpto = 0;
        int i2 = 0;
        while (true) {
            block11: {
                Object var15_15;
                if (i2 >= numSegments) {
                    this.writer = writer;
                    this.initialize(readers.toArray(new SegmentReader[readers.size()]));
                    return;
                }
                IOException prior = null;
                boolean success2 = false;
                try {
                    try {
                        SegmentInfo info = infos.info(i2);
                        assert (info.dir == dir);
                        SegmentReader reader = writer.readerPool.getReadOnlyClone(info, true, termInfosIndexDivisor);
                        if (reader.numDocs() > 0 || writer.getKeepFullyDeletedSegments()) {
                            readers.add(reader);
                            ++infosUpto;
                        } else {
                            reader.close();
                            this.segmentInfos.remove(infosUpto);
                        }
                        success2 = true;
                    }
                    catch (IOException ex) {
                        prior = ex;
                        var15_15 = null;
                        if (!success2) {
                            IOUtils.closeWhileHandlingException(prior, readers);
                        }
                        break block11;
                    }
                    var15_15 = null;
                    if (success2) break block11;
                }
                catch (Throwable throwable) {
                    var15_15 = null;
                    if (!success2) {
                        IOUtils.closeWhileHandlingException(prior, readers);
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(prior, readers);
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    DirectoryReader(Directory directory, SegmentInfos infos, SegmentReader[] oldReaders, int[] oldStarts, Map<String, byte[]> oldNormsCache, boolean readOnly, boolean doClone, int termInfosIndexDivisor) throws IOException {
        this.directory = directory;
        this.readOnly = readOnly;
        this.segmentInfos = infos;
        this.termInfosIndexDivisor = termInfosIndexDivisor;
        this.applyAllDeletes = false;
        HashMap<String, Integer> segmentReaders = new HashMap<String, Integer>();
        if (oldReaders != null) {
            for (int i2 = 0; i2 < oldReaders.length; ++i2) {
                segmentReaders.put(oldReaders[i2].getSegmentName(), i2);
            }
        }
        SegmentReader[] newReaders = new SegmentReader[infos.size()];
        boolean[] readerShared = new boolean[infos.size()];
        for (int i3 = infos.size() - 1; i3 >= 0; --i3) {
            IOException ex2222;
            Object var18_22;
            boolean success2;
            IOException prior;
            block35: {
                Integer oldReaderIndex = (Integer)segmentReaders.get(infos.info((int)i3).name);
                newReaders[i3] = oldReaderIndex == null ? null : oldReaders[oldReaderIndex];
                prior = null;
                success2 = false;
                try {
                    SegmentReader newReader;
                    if (newReaders[i3] == null || infos.info(i3).getUseCompoundFile() != newReaders[i3].getSegmentInfo().getUseCompoundFile()) {
                        assert (!doClone);
                        newReader = SegmentReader.get(readOnly, infos.info(i3), termInfosIndexDivisor);
                        readerShared[i3] = false;
                        newReaders[i3] = newReader;
                    } else {
                        newReader = newReaders[i3].reopenSegment(infos.info(i3), doClone, readOnly);
                        if (newReader == null) {
                            readerShared[i3] = true;
                            newReaders[i3].incRef();
                        } else {
                            readerShared[i3] = false;
                            newReaders[i3] = newReader;
                        }
                    }
                    success2 = true;
                    var18_22 = null;
                    if (success2) break block35;
                    ++i3;
                }
                catch (Throwable throwable) {
                    var18_22 = null;
                    if (!success2) {
                        ++i3;
                        while (i3 < infos.size()) {
                            block38: {
                                if (newReaders[i3] != null) {
                                    try {
                                        if (!readerShared[i3]) {
                                            newReaders[i3].close();
                                        } else {
                                            newReaders[i3].decRef();
                                        }
                                    }
                                    catch (IOException ex2222) {
                                        if (prior != null) break block38;
                                        prior = ex2222;
                                    }
                                }
                            }
                            ++i3;
                        }
                    }
                    if (prior != null) {
                        throw prior;
                    }
                    throw throwable;
                }
                while (i3 < infos.size()) {
                    block36: {
                        if (newReaders[i3] != null) {
                            try {
                                if (!readerShared[i3]) {
                                    newReaders[i3].close();
                                } else {
                                    newReaders[i3].decRef();
                                }
                            }
                            catch (IOException ex2222) {
                                if (prior != null) break block36;
                                prior = ex2222;
                            }
                        }
                    }
                    ++i3;
                }
            }
            if (prior == null) continue;
            throw prior;
            {
                catch (IOException ex3) {
                    prior = ex3;
                    var18_22 = null;
                    if (!success2) {
                        ++i3;
                        while (i3 < infos.size()) {
                            block37: {
                                if (newReaders[i3] != null) {
                                    try {
                                        if (!readerShared[i3]) {
                                            newReaders[i3].close();
                                        } else {
                                            newReaders[i3].decRef();
                                        }
                                    }
                                    catch (IOException ex2222) {
                                        if (prior != null) break block37;
                                        prior = ex2222;
                                    }
                                }
                            }
                            ++i3;
                        }
                    }
                    if (prior == null) continue;
                    throw prior;
                }
            }
        }
        this.initialize(newReaders);
        if (oldNormsCache != null) {
            for (Map.Entry<String, byte[]> entry : oldNormsCache.entrySet()) {
                String field2 = entry.getKey();
                if (!this.hasNorms(field2)) continue;
                byte[] oldBytes = entry.getValue();
                byte[] bytes2 = new byte[this.maxDoc()];
                for (int i4 = 0; i4 < this.subReaders.length; ++i4) {
                    Integer oldReaderIndex = (Integer)segmentReaders.get(this.subReaders[i4].getSegmentName());
                    if (oldReaderIndex != null && (oldReaders[oldReaderIndex] == this.subReaders[i4] || oldReaders[oldReaderIndex.intValue()].norms.get(field2) == this.subReaders[i4].norms.get(field2))) {
                        System.arraycopy(oldBytes, oldStarts[oldReaderIndex], bytes2, this.starts[i4], this.starts[i4 + 1] - this.starts[i4]);
                        continue;
                    }
                    this.subReaders[i4].norms(field2, bytes2, this.starts[i4]);
                }
                this.normsCache.put(field2, bytes2);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.hasChanges) {
            buffer.append("*");
        }
        buffer.append(this.getClass().getSimpleName());
        buffer.append('(');
        String segmentsFile = this.segmentInfos.getSegmentsFileName();
        if (segmentsFile != null) {
            buffer.append(segmentsFile);
        }
        if (this.writer != null) {
            buffer.append(":nrt");
        }
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            buffer.append(' ');
            buffer.append(this.subReaders[i2]);
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public FieldInfos getFieldInfos() {
        throw new UnsupportedOperationException("call getFieldInfos() on each sub reader, or use ReaderUtil.getMergedFieldInfos, instead");
    }

    private void initialize(SegmentReader[] subReaders) throws IOException {
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        for (int i2 = 0; i2 < subReaders.length; ++i2) {
            SegmentReader reader = subReaders[i2];
            this.starts[i2] = this.maxDoc;
            this.maxDoc += reader.maxDoc();
            if (!reader.hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
        if (!this.readOnly) {
            this.maxIndexVersion = SegmentInfos.readCurrentVersion(this.directory);
        }
    }

    @Override
    public final synchronized Object clone() {
        try {
            return this.clone(this.readOnly);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    @Deprecated
    public final synchronized IndexReader clone(boolean openReadOnly) throws CorruptIndexException, IOException {
        DirectoryReader newReader = this.doOpenIfChanged((SegmentInfos)this.segmentInfos.clone(), true, openReadOnly);
        if (this != newReader) {
            newReader.deletionPolicy = this.deletionPolicy;
        }
        newReader.writer = this.writer;
        if (!openReadOnly && this.writeLock != null) {
            assert (this.writer == null);
            newReader.writeLock = this.writeLock;
            newReader.hasChanges = this.hasChanges;
            newReader.hasDeletions = this.hasDeletions;
            this.writeLock = null;
            this.hasChanges = false;
        }
        return newReader;
    }

    @Override
    protected final IndexReader doOpenIfChanged() throws CorruptIndexException, IOException {
        return this.doOpenIfChanged(this.readOnly, null);
    }

    @Override
    @Deprecated
    protected final IndexReader doOpenIfChanged(boolean openReadOnly) throws CorruptIndexException, IOException {
        return this.doOpenIfChanged(openReadOnly, null);
    }

    @Override
    protected final IndexReader doOpenIfChanged(IndexCommit commit) throws CorruptIndexException, IOException {
        return this.doOpenIfChanged(true, commit);
    }

    @Override
    protected final IndexReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) throws CorruptIndexException, IOException {
        if (writer == this.writer && applyAllDeletes == this.applyAllDeletes) {
            return this.doOpenIfChanged();
        }
        return super.doOpenIfChanged(writer, applyAllDeletes);
    }

    private final IndexReader doOpenFromWriter(boolean openReadOnly, IndexCommit commit) throws CorruptIndexException, IOException {
        assert (this.readOnly);
        if (!openReadOnly) {
            throw new IllegalArgumentException("a reader obtained from IndexWriter.getReader() can only be reopened with openReadOnly=true (got false)");
        }
        if (commit != null) {
            throw new IllegalArgumentException("a reader obtained from IndexWriter.getReader() cannot currently accept a commit");
        }
        if (this.writer.nrtIsCurrent(this.segmentInfos)) {
            return null;
        }
        IndexReader reader = this.writer.getReader(this.applyAllDeletes);
        if (reader.getVersion() == this.segmentInfos.getVersion()) {
            reader.decRef();
            return null;
        }
        return reader;
    }

    private IndexReader doOpenIfChanged(boolean openReadOnly, IndexCommit commit) throws CorruptIndexException, IOException {
        this.ensureOpen();
        assert (commit == null || openReadOnly);
        if (this.writer != null) {
            return this.doOpenFromWriter(openReadOnly, commit);
        }
        return this.doOpenNoWriter(openReadOnly, commit);
    }

    private synchronized IndexReader doOpenNoWriter(final boolean openReadOnly, IndexCommit commit) throws CorruptIndexException, IOException {
        if (commit == null) {
            if (this.hasChanges) {
                assert (!this.readOnly);
                assert (this.writeLock != null);
                assert (this.isCurrent());
                if (openReadOnly) {
                    return this.clone(openReadOnly);
                }
                return null;
            }
            if (this.isCurrent()) {
                if (openReadOnly != this.readOnly) {
                    return this.clone(openReadOnly);
                }
                return null;
            }
        } else {
            if (this.directory != commit.getDirectory()) {
                throw new IOException("the specified commit does not match the specified Directory");
            }
            if (this.segmentInfos != null && commit.getSegmentsFileName().equals(this.segmentInfos.getSegmentsFileName())) {
                if (this.readOnly != openReadOnly) {
                    return this.clone(openReadOnly);
                }
                return null;
            }
        }
        return (IndexReader)new SegmentInfos.FindSegmentsFile(this.directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.directory, segmentFileName);
                return DirectoryReader.this.doOpenIfChanged(infos, false, openReadOnly);
            }
        }.run(commit);
    }

    private synchronized DirectoryReader doOpenIfChanged(SegmentInfos infos, boolean doClone, boolean openReadOnly) throws CorruptIndexException, IOException {
        DirectoryReader reader = openReadOnly ? new ReadOnlyDirectoryReader(this.directory, infos, this.subReaders, this.starts, this.normsCache, doClone, this.termInfosIndexDivisor) : new DirectoryReader(this.directory, infos, this.subReaders, this.starts, this.normsCache, false, doClone, this.termInfosIndexDivisor);
        return reader;
    }

    @Override
    public long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int i2 = this.readerIndex(n);
        return this.subReaders[i2].getTermFreqVectors(n - this.starts[i2]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String field2) throws IOException {
        this.ensureOpen();
        int i2 = this.readerIndex(n);
        return this.subReaders[i2].getTermFreqVector(n - this.starts[i2], field2);
    }

    @Override
    public void getTermFreqVector(int docNumber, String field2, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i2 = this.readerIndex(docNumber);
        this.subReaders[i2].getTermFreqVector(docNumber - this.starts[i2], field2, mapper);
    }

    @Override
    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i2 = this.readerIndex(docNumber);
        this.subReaders[i2].getTermFreqVector(docNumber - this.starts[i2], mapper);
    }

    @Override
    @Deprecated
    public boolean isOptimized() {
        this.ensureOpen();
        return this.segmentInfos.size() == 1 && !this.hasDeletions();
    }

    @Override
    public int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
                n += this.subReaders[i2].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int i2 = this.readerIndex(n);
        return this.subReaders[i2].document(n - this.starts[i2], fieldSelector);
    }

    @Override
    public boolean isDeleted(int n) {
        int i2 = this.readerIndex(n);
        return this.subReaders[i2].isDeleted(n - this.starts[i2]);
    }

    @Override
    public boolean hasDeletions() {
        this.ensureOpen();
        return this.hasDeletions;
    }

    @Override
    @Deprecated
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int i2 = this.readerIndex(n);
        this.subReaders[i2].deleteDocument(n - this.starts[i2]);
        this.hasDeletions = true;
    }

    @Override
    @Deprecated
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            this.subReaders[i2].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        return DirectoryReader.readerIndex(n, this.starts, this.subReaders.length);
    }

    static final int readerIndex(int n, int[] starts, int numSubReaders) {
        int lo = 0;
        int hi = numSubReaders - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < numSubReaders && starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    @Override
    public boolean hasNorms(String field2) throws IOException {
        this.ensureOpen();
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            if (!this.subReaders[i2].hasNorms(field2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized byte[] norms(String field2) throws IOException {
        this.ensureOpen();
        byte[] bytes2 = this.normsCache.get(field2);
        if (bytes2 != null) {
            return bytes2;
        }
        if (!this.hasNorms(field2)) {
            return null;
        }
        bytes2 = new byte[this.maxDoc()];
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            this.subReaders[i2].norms(field2, bytes2, this.starts[i2]);
        }
        this.normsCache.put(field2, bytes2);
        return bytes2;
    }

    @Override
    public synchronized void norms(String field2, byte[] result2, int offset2) throws IOException {
        this.ensureOpen();
        byte[] bytes2 = this.normsCache.get(field2);
        if (bytes2 == null && !this.hasNorms(field2)) {
            Arrays.fill(result2, offset2, result2.length, Similarity.getDefault().encodeNormValue(1.0f));
        } else if (bytes2 != null) {
            System.arraycopy(bytes2, 0, result2, offset2, this.maxDoc());
        } else {
            for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
                this.subReaders[i2].norms(field2, result2, offset2 + this.starts[i2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    protected void doSetNorm(int n, String field2, byte value2) throws CorruptIndexException, IOException {
        Map<String, byte[]> map = this.normsCache;
        synchronized (map) {
            this.normsCache.remove(field2);
        }
        int i2 = this.readerIndex(n);
        this.subReaders[i2].setNorm(n - this.starts[i2], field2, value2);
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].terms();
        }
        return new MultiTermEnum(this, this.subReaders, this.starts, null);
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].terms(term);
        }
        return new MultiTermEnum(this, this.subReaders, this.starts, term);
    }

    @Override
    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        int total2 = 0;
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            total2 += this.subReaders[i2].docFreq(t);
        }
        return total2;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termDocs();
        }
        return new MultiTermDocs(this, this.subReaders, this.starts);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termDocs(term);
        }
        return super.termDocs(term);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termPositions();
        }
        return new MultiTermPositions(this, this.subReaders, this.starts);
    }

    @Override
    @Deprecated
    protected void acquireWriteLock() throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        if (this.readOnly) {
            ReadOnlySegmentReader.noWrite();
        }
        if (this.segmentInfos != null) {
            this.ensureOpen();
            if (this.stale) {
                throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
            }
            if (this.writeLock == null) {
                Lock writeLock = this.directory.makeLock("write.lock");
                if (!writeLock.obtain(IndexWriterConfig.WRITE_LOCK_TIMEOUT)) {
                    throw new LockObtainFailedException("Index locked for write: " + writeLock);
                }
                this.writeLock = writeLock;
                if (SegmentInfos.readCurrentVersion(this.directory) > this.maxIndexVersion) {
                    this.stale = true;
                    this.writeLock.release();
                    this.writeLock = null;
                    throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    protected void doCommit(Map<String, String> commitUserData) throws IOException {
        if (this.hasChanges) {
            IndexFileDeleter deleter;
            block6: {
                this.segmentInfos.setUserData(commitUserData);
                deleter = new IndexFileDeleter(this.directory, this.deletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : this.deletionPolicy, this.segmentInfos, null, null);
                this.segmentInfos.updateGeneration(deleter.getLastSegmentInfos());
                this.segmentInfos.changed();
                this.startCommit();
                List<SegmentInfo> rollbackSegments = this.segmentInfos.createBackupSegmentInfos(false);
                boolean success2 = false;
                try {
                    for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
                        this.subReaders[i2].commit();
                    }
                    this.segmentInfos.pruneDeletedSegments();
                    this.directory.sync(this.segmentInfos.files(this.directory, false));
                    this.segmentInfos.commit(this.directory);
                    success2 = true;
                    Object var7_6 = null;
                    if (success2) break block6;
                    this.rollbackCommit();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!success2) {
                        this.rollbackCommit();
                        deleter.refresh();
                        this.segmentInfos.rollbackSegmentInfos(rollbackSegments);
                    }
                    throw throwable;
                }
                deleter.refresh();
                this.segmentInfos.rollbackSegmentInfos(rollbackSegments);
                {
                }
            }
            deleter.checkpoint(this.segmentInfos, true);
            deleter.close();
            this.maxIndexVersion = this.segmentInfos.getVersion();
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
        }
        this.hasChanges = false;
    }

    void startCommit() {
        this.rollbackHasChanges = this.hasChanges;
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            this.subReaders[i2].startCommit();
        }
    }

    void rollbackCommit() {
        this.hasChanges = this.rollbackHasChanges;
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            this.subReaders[i2].rollbackCommit();
        }
    }

    @Override
    public Map<String, String> getCommitUserData() {
        this.ensureOpen();
        return this.segmentInfos.getUserData();
    }

    @Override
    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (this.writer == null || this.writer.isClosed()) {
            return SegmentInfos.readCurrentVersion(this.directory) == this.segmentInfos.getVersion();
        }
        return this.writer.nrtIsCurrent(this.segmentInfos);
    }

    @Override
    protected synchronized void doClose() throws IOException {
        IOException ioe = null;
        this.normsCache = null;
        for (int i2 = 0; i2 < this.subReaders.length; ++i2) {
            try {
                this.subReaders[i2].decRef();
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (this.writer != null) {
            this.writer.deletePendingFiles();
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public IndexReader[] getSequentialSubReaders() {
        return this.subReaders;
    }

    @Override
    public Directory directory() {
        return this.directory;
    }

    @Override
    public int getTermInfosIndexDivisor() {
        this.ensureOpen();
        return this.termInfosIndexDivisor;
    }

    @Override
    public IndexCommit getIndexCommit() throws IOException {
        this.ensureOpen();
        return new ReaderCommit(this.segmentInfos, this.directory);
    }

    public static Collection<IndexCommit> listCommits(Directory dir) throws IOException {
        String[] files = dir.listAll();
        ArrayList<IndexCommit> commits = new ArrayList<IndexCommit>();
        SegmentInfos latest = new SegmentInfos();
        latest.read(dir);
        long currentGen = latest.getGeneration();
        commits.add(new ReaderCommit(latest, dir));
        for (int i2 = 0; i2 < files.length; ++i2) {
            String fileName = files[i2];
            if (!fileName.startsWith("segments") || fileName.equals("segments.gen") || SegmentInfos.generationFromSegmentsFileName(fileName) >= currentGen) continue;
            SegmentInfos sis = new SegmentInfos();
            try {
                sis.read(dir, fileName);
            }
            catch (FileNotFoundException fnfe) {
                sis = null;
            }
            if (sis == null) continue;
            commits.add(new ReaderCommit(sis, dir));
        }
        Collections.sort(commits);
        return commits;
    }

    static class MultiTermPositions
    extends MultiTermDocs
    implements TermPositions {
        public MultiTermPositions(IndexReader topReader, IndexReader[] r, int[] s2) {
            super(topReader, r, s2);
        }

        protected TermDocs termDocs(IndexReader reader) throws IOException {
            return reader.termPositions();
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.current).nextPosition();
        }

        public int getPayloadLength() {
            return ((TermPositions)this.current).getPayloadLength();
        }

        public byte[] getPayload(byte[] data2, int offset2) throws IOException {
            return ((TermPositions)this.current).getPayload(data2, offset2);
        }

        public boolean isPayloadAvailable() {
            return ((TermPositions)this.current).isPayloadAvailable();
        }
    }

    static class MultiTermDocs
    implements TermDocs {
        IndexReader topReader;
        protected IndexReader[] readers;
        protected int[] starts;
        protected Term term;
        protected int base = 0;
        protected int pointer = 0;
        private TermDocs[] readerTermDocs;
        protected TermDocs current;
        private MultiTermEnum tenum;
        int matchingSegmentPos;
        SegmentMergeInfo smi;

        public MultiTermDocs(IndexReader topReader, IndexReader[] r, int[] s2) {
            this.topReader = topReader;
            this.readers = r;
            this.starts = s2;
            this.readerTermDocs = new TermDocs[r.length];
        }

        public int doc() {
            return this.base + this.current.doc();
        }

        public int freq() {
            return this.current.freq();
        }

        public void seek(Term term) {
            this.term = term;
            this.base = 0;
            this.pointer = 0;
            this.current = null;
            this.tenum = null;
            this.smi = null;
            this.matchingSegmentPos = 0;
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
            if (termEnum instanceof MultiTermEnum) {
                this.tenum = (MultiTermEnum)termEnum;
                if (this.topReader != this.tenum.topReader) {
                    this.tenum = null;
                }
            }
        }

        public boolean next() throws IOException {
            while (true) {
                if (this.current != null && this.current.next()) {
                    return true;
                }
                if (this.pointer >= this.readers.length) break;
                if (this.tenum != null) {
                    this.smi = this.tenum.matchingSegments[this.matchingSegmentPos++];
                    if (this.smi == null) {
                        this.pointer = this.readers.length;
                        return false;
                    }
                    this.pointer = this.smi.ord;
                }
                this.base = this.starts[this.pointer];
                this.current = this.termDocs(this.pointer++);
            }
            return false;
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int end2;
            while (true) {
                if (this.current == null) {
                    if (this.pointer < this.readers.length) {
                        if (this.tenum != null) {
                            this.smi = this.tenum.matchingSegments[this.matchingSegmentPos++];
                            if (this.smi == null) {
                                this.pointer = this.readers.length;
                                return 0;
                            }
                            this.pointer = this.smi.ord;
                        }
                        this.base = this.starts[this.pointer];
                        this.current = this.termDocs(this.pointer++);
                        continue;
                    }
                    return 0;
                }
                end2 = this.current.read(docs, freqs);
                if (end2 != 0) break;
                this.current = null;
            }
            int b = this.base;
            int i2 = 0;
            while (i2 < end2) {
                int n = i2++;
                docs[n] = docs[n] + b;
            }
            return end2;
        }

        public boolean skipTo(int target) throws IOException {
            while (true) {
                if (this.current != null && this.current.skipTo(target - this.base)) {
                    return true;
                }
                if (this.pointer >= this.readers.length) break;
                if (this.tenum != null) {
                    SegmentMergeInfo smi;
                    if ((smi = this.tenum.matchingSegments[this.matchingSegmentPos++]) == null) {
                        this.pointer = this.readers.length;
                        return false;
                    }
                    this.pointer = smi.ord;
                }
                this.base = this.starts[this.pointer];
                this.current = this.termDocs(this.pointer++);
            }
            return false;
        }

        private TermDocs termDocs(int i2) throws IOException {
            TermDocs result2 = this.readerTermDocs[i2];
            if (result2 == null) {
                result2 = this.readerTermDocs[i2] = this.termDocs(this.readers[i2]);
            }
            if (this.smi != null) {
                assert (this.smi.ord == i2);
                assert (this.smi.termEnum.term().equals(this.term));
                result2.seek(this.smi.termEnum);
            } else {
                result2.seek(this.term);
            }
            return result2;
        }

        protected TermDocs termDocs(IndexReader reader) throws IOException {
            return this.term == null ? reader.termDocs(null) : reader.termDocs();
        }

        public void close() throws IOException {
            for (int i2 = 0; i2 < this.readerTermDocs.length; ++i2) {
                if (this.readerTermDocs[i2] == null) continue;
                this.readerTermDocs[i2].close();
            }
        }
    }

    static class MultiTermEnum
    extends TermEnum {
        IndexReader topReader;
        private SegmentMergeQueue queue;
        private Term term;
        private int docFreq;
        final SegmentMergeInfo[] matchingSegments;

        public MultiTermEnum(IndexReader topReader, IndexReader[] readers, int[] starts, Term t) throws IOException {
            this.topReader = topReader;
            this.queue = new SegmentMergeQueue(readers.length);
            this.matchingSegments = new SegmentMergeInfo[readers.length + 1];
            for (int i2 = 0; i2 < readers.length; ++i2) {
                IndexReader reader = readers[i2];
                TermEnum termEnum = t != null ? reader.terms(t) : reader.terms();
                SegmentMergeInfo smi = new SegmentMergeInfo(starts[i2], termEnum, reader);
                smi.ord = i2;
                if (t == null ? smi.next() : termEnum.term() != null) {
                    this.queue.add(smi);
                    continue;
                }
                smi.close();
            }
            if (t != null && this.queue.size() > 0) {
                this.next();
            }
        }

        public boolean next() throws IOException {
            SegmentMergeInfo smi;
            for (int i2 = 0; i2 < this.matchingSegments.length && (smi = this.matchingSegments[i2]) != null; ++i2) {
                if (smi.next()) {
                    this.queue.add(smi);
                    continue;
                }
                smi.close();
            }
            int numMatchingSegments = 0;
            this.matchingSegments[0] = null;
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            if (top == null) {
                this.term = null;
                return false;
            }
            this.term = top.term;
            this.docFreq = 0;
            while (top != null && this.term.compareTo(top.term) == 0) {
                this.matchingSegments[numMatchingSegments++] = top;
                this.queue.pop();
                this.docFreq += top.termEnum.docFreq();
                top = (SegmentMergeInfo)this.queue.top();
            }
            this.matchingSegments[numMatchingSegments] = null;
            return true;
        }

        public Term term() {
            return this.term;
        }

        public int docFreq() {
            return this.docFreq;
        }

        public void close() throws IOException {
            this.queue.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReaderCommit
    extends IndexCommit {
        private String segmentsFileName;
        Collection<String> files;
        Directory dir;
        long generation;
        long version;
        final Map<String, String> userData;
        private final int segmentCount;

        ReaderCommit(SegmentInfos infos, Directory dir) throws IOException {
            this.segmentsFileName = infos.getSegmentsFileName();
            this.dir = dir;
            this.userData = infos.getUserData();
            this.files = Collections.unmodifiableCollection(infos.files(dir, true));
            this.version = infos.getVersion();
            this.generation = infos.getGeneration();
            this.segmentCount = infos.size();
        }

        public String toString() {
            return "DirectoryReader.ReaderCommit(" + this.segmentsFileName + ")";
        }

        @Override
        public int getSegmentCount() {
            return this.segmentCount;
        }

        @Override
        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        @Override
        public Collection<String> getFileNames() {
            return this.files;
        }

        @Override
        public Directory getDirectory() {
            return this.dir;
        }

        @Override
        public long getVersion() {
            return this.version;
        }

        @Override
        public long getGeneration() {
            return this.generation;
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public Map<String, String> getUserData() {
            return this.userData;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }
    }
}

