/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.BufferedDeletes;
import org.apache.lucene.index.BufferedDeletesStream;
import org.apache.lucene.index.FrozenBufferedDeletes;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CoalescedDeletes {
    final Map<Query, Integer> queries = new HashMap<Query, Integer>();
    final List<Iterable<Term>> iterables = new ArrayList<Iterable<Term>>();

    CoalescedDeletes() {
    }

    public String toString() {
        return "CoalescedDeletes(termSets=" + this.iterables.size() + ",queries=" + this.queries.size() + ")";
    }

    void update(FrozenBufferedDeletes in) {
        this.iterables.add(in.termsIterable());
        for (int queryIdx = 0; queryIdx < in.queries.length; ++queryIdx) {
            Query query = in.queries[queryIdx];
            this.queries.put(query, BufferedDeletes.MAX_INT);
        }
    }

    public Iterable<Term> termsIterable() {
        return new Iterable<Term>(){

            @Override
            public Iterator<Term> iterator() {
                ArrayList<Iterator<Term>> subs = new ArrayList<Iterator<Term>>(CoalescedDeletes.this.iterables.size());
                for (Iterable<Term> iterable : CoalescedDeletes.this.iterables) {
                    subs.add(iterable.iterator());
                }
                return CoalescedDeletes.mergedIterator(subs);
            }
        };
    }

    public Iterable<BufferedDeletesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedDeletesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedDeletesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedDeletesStream.QueryAndLimit>(){
                    private final Iterator<Map.Entry<Query, Integer>> iter;
                    {
                        this.iter = CoalescedDeletes.this.queries.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public BufferedDeletesStream.QueryAndLimit next() {
                        Map.Entry<Query, Integer> ent = this.iter.next();
                        return new BufferedDeletesStream.QueryAndLimit(ent.getKey(), ent.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static Iterator<Term> mergedIterator(final List<Iterator<Term>> iterators) {
        return new Iterator<Term>(){
            Term current;
            TermMergeQueue queue;
            SubIterator[] top;
            int numTop;
            {
                this.queue = new TermMergeQueue(iterators.size());
                this.top = new SubIterator[iterators.size()];
                int index2 = 0;
                for (Iterator iterator : iterators) {
                    if (!iterator.hasNext()) continue;
                    SubIterator sub3 = new SubIterator();
                    sub3.current = (Term)iterator.next();
                    sub3.iterator = iterator;
                    sub3.index = index2++;
                    this.queue.add(sub3);
                }
            }

            @Override
            public boolean hasNext() {
                if (this.queue.size() > 0) {
                    return true;
                }
                for (int i2 = 0; i2 < this.numTop; ++i2) {
                    if (!this.top[i2].iterator.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Term next() {
                this.pushTop();
                if (this.queue.size() > 0) {
                    this.pullTop();
                } else {
                    this.current = null;
                }
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void pullTop() {
                assert (this.numTop == 0);
                do {
                    this.top[this.numTop++] = (SubIterator)this.queue.pop();
                } while (this.queue.size() != 0 && ((SubIterator)this.queue.top()).current.equals(this.top[0].current));
                this.current = this.top[0].current;
            }

            private void pushTop() {
                for (int i2 = 0; i2 < this.numTop; ++i2) {
                    if (this.top[i2].iterator.hasNext()) {
                        this.top[i2].current = this.top[i2].iterator.next();
                        this.queue.add(this.top[i2]);
                        continue;
                    }
                    this.top[i2].current = null;
                }
                this.numTop = 0;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TermMergeQueue
    extends PriorityQueue<SubIterator> {
        TermMergeQueue(int size2) {
            this.initialize(size2);
        }

        @Override
        protected boolean lessThan(SubIterator a, SubIterator b) {
            int cmp2 = a.current.compareTo(b.current);
            if (cmp2 != 0) {
                return cmp2 < 0;
            }
            return a.index < b.index;
        }
    }

    private static class SubIterator {
        Iterator<Term> iterator;
        Term current;
        int index;

        private SubIterator() {
        }
    }
}

