/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;

public final class NumericField
extends AbstractField {
    private transient NumericTokenStream numericTS;
    private DataType type;
    private final int precisionStep;

    public NumericField(String name2) {
        this(name2, 4, Field.Store.NO, true);
    }

    public NumericField(String name2, Field.Store store, boolean index2) {
        this(name2, 4, store, index2);
    }

    public NumericField(String name2, int precisionStep) {
        this(name2, precisionStep, Field.Store.NO, true);
    }

    public NumericField(String name2, int precisionStep, Field.Store store, boolean index2) {
        super(name2, store, index2 ? Field.Index.ANALYZED_NO_NORMS : Field.Index.NO, Field.TermVector.NO);
        if (precisionStep < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        this.precisionStep = precisionStep;
        this.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
    }

    public TokenStream tokenStreamValue() {
        if (!this.isIndexed()) {
            return null;
        }
        if (this.numericTS == null) {
            this.numericTS = new NumericTokenStream(this.precisionStep);
            if (this.fieldsData != null) {
                assert (this.type != null);
                Number val = (Number)this.fieldsData;
                switch (this.type) {
                    case INT: {
                        this.numericTS.setIntValue(val.intValue());
                        break;
                    }
                    case LONG: {
                        this.numericTS.setLongValue(val.longValue());
                        break;
                    }
                    case FLOAT: {
                        this.numericTS.setFloatValue(val.floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.numericTS.setDoubleValue(val.doubleValue());
                        break;
                    }
                    default: {
                        assert (false) : "Should never get here";
                        break;
                    }
                }
            }
        }
        return this.numericTS;
    }

    public byte[] getBinaryValue(byte[] result2) {
        return null;
    }

    public Reader readerValue() {
        return null;
    }

    public String stringValue() {
        return this.fieldsData == null ? null : this.fieldsData.toString();
    }

    public Number getNumericValue() {
        return (Number)this.fieldsData;
    }

    public int getPrecisionStep() {
        return this.precisionStep;
    }

    public DataType getDataType() {
        return this.type;
    }

    public NumericField setLongValue(long value2) {
        if (this.numericTS != null) {
            this.numericTS.setLongValue(value2);
        }
        this.fieldsData = value2;
        this.type = DataType.LONG;
        return this;
    }

    public NumericField setIntValue(int value2) {
        if (this.numericTS != null) {
            this.numericTS.setIntValue(value2);
        }
        this.fieldsData = value2;
        this.type = DataType.INT;
        return this;
    }

    public NumericField setDoubleValue(double value2) {
        if (this.numericTS != null) {
            this.numericTS.setDoubleValue(value2);
        }
        this.fieldsData = value2;
        this.type = DataType.DOUBLE;
        return this;
    }

    public NumericField setFloatValue(float value2) {
        if (this.numericTS != null) {
            this.numericTS.setFloatValue(value2);
        }
        this.fieldsData = Float.valueOf(value2);
        this.type = DataType.FLOAT;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

