/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Document
implements Serializable {
    List<Fieldable> fields = new ArrayList<Fieldable>();
    private float boost = 1.0f;
    private static final Field[] NO_FIELDS = new Field[0];
    private static final Fieldable[] NO_FIELDABLES = new Fieldable[0];
    private static final String[] NO_STRINGS = new String[0];
    private static final byte[][] NO_BYTES = new byte[0][];

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    public final void add(Fieldable field2) {
        this.fields.add(field2);
    }

    public final void removeField(String name2) {
        Iterator<Fieldable> it = this.fields.iterator();
        while (it.hasNext()) {
            Fieldable field2 = it.next();
            if (!field2.name().equals(name2)) continue;
            it.remove();
            return;
        }
    }

    public final void removeFields(String name2) {
        Iterator<Fieldable> it = this.fields.iterator();
        while (it.hasNext()) {
            Fieldable field2 = it.next();
            if (!field2.name().equals(name2)) continue;
            it.remove();
        }
    }

    @Deprecated
    public final Field getField(String name2) {
        return (Field)this.getFieldable(name2);
    }

    public Fieldable getFieldable(String name2) {
        for (Fieldable field2 : this.fields) {
            if (!field2.name().equals(name2)) continue;
            return field2;
        }
        return null;
    }

    public final String get(String name2) {
        for (Fieldable field2 : this.fields) {
            if (!field2.name().equals(name2) || field2.isBinary()) continue;
            return field2.stringValue();
        }
        return null;
    }

    public final List<Fieldable> getFields() {
        return this.fields;
    }

    @Deprecated
    public final Field[] getFields(String name2) {
        ArrayList<Field> result2 = new ArrayList<Field>();
        for (Fieldable field2 : this.fields) {
            if (!field2.name().equals(name2)) continue;
            result2.add((Field)field2);
        }
        if (result2.size() == 0) {
            return NO_FIELDS;
        }
        return result2.toArray(new Field[result2.size()]);
    }

    public Fieldable[] getFieldables(String name2) {
        ArrayList<Fieldable> result2 = new ArrayList<Fieldable>();
        for (Fieldable field2 : this.fields) {
            if (!field2.name().equals(name2)) continue;
            result2.add(field2);
        }
        if (result2.size() == 0) {
            return NO_FIELDABLES;
        }
        return result2.toArray(new Fieldable[result2.size()]);
    }

    public final String[] getValues(String name2) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (Fieldable field2 : this.fields) {
            if (!field2.name().equals(name2) || field2.isBinary()) continue;
            result2.add(field2.stringValue());
        }
        if (result2.size() == 0) {
            return NO_STRINGS;
        }
        return result2.toArray(new String[result2.size()]);
    }

    public final byte[][] getBinaryValues(String name2) {
        ArrayList<byte[]> result2 = new ArrayList<byte[]>();
        for (Fieldable field2 : this.fields) {
            if (!field2.name().equals(name2) || !field2.isBinary()) continue;
            result2.add(field2.getBinaryValue());
        }
        if (result2.size() == 0) {
            return NO_BYTES;
        }
        return (byte[][])result2.toArray((T[])new byte[result2.size()][]);
    }

    public final byte[] getBinaryValue(String name2) {
        for (Fieldable field2 : this.fields) {
            if (!field2.name().equals(name2) || !field2.isBinary()) continue;
            return field2.getBinaryValue();
        }
        return null;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Document<");
        for (int i2 = 0; i2 < this.fields.size(); ++i2) {
            Fieldable field2 = this.fields.get(i2);
            buffer.append(field2.toString());
            if (i2 == this.fields.size() - 1) continue;
            buffer.append(" ");
        }
        buffer.append(">");
        return buffer.toString();
    }
}

