/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.StringHelper;

public abstract class AbstractField
implements Fieldable {
    protected String name = "body";
    protected boolean storeTermVector = false;
    protected boolean storeOffsetWithTermVector = false;
    protected boolean storePositionWithTermVector = false;
    protected boolean omitNorms = false;
    protected boolean isStored = false;
    protected boolean isIndexed = true;
    protected boolean isTokenized = true;
    protected boolean isBinary = false;
    protected boolean lazy = false;
    protected FieldInfo.IndexOptions indexOptions = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
    protected float boost = 1.0f;
    protected Object fieldsData = null;
    protected TokenStream tokenStream;
    protected int binaryLength;
    protected int binaryOffset;

    protected AbstractField() {
    }

    protected AbstractField(String name2, Field.Store store, Field.Index index2, Field.TermVector termVector) {
        if (name2 == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = StringHelper.intern(name2);
        this.isStored = store.isStored();
        this.isIndexed = index2.isIndexed();
        this.isTokenized = index2.isAnalyzed();
        this.omitNorms = index2.omitNorms();
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    public String name() {
        return this.name;
    }

    protected void setStoreTermVector(Field.TermVector termVector) {
        this.storeTermVector = termVector.isStored();
        this.storePositionWithTermVector = termVector.withPositions();
        this.storeOffsetWithTermVector = termVector.withOffsets();
    }

    public final boolean isStored() {
        return this.isStored;
    }

    public final boolean isIndexed() {
        return this.isIndexed;
    }

    public final boolean isTokenized() {
        return this.isTokenized;
    }

    public final boolean isTermVectorStored() {
        return this.storeTermVector;
    }

    public boolean isStoreOffsetWithTermVector() {
        return this.storeOffsetWithTermVector;
    }

    public boolean isStorePositionWithTermVector() {
        return this.storePositionWithTermVector;
    }

    public final boolean isBinary() {
        return this.isBinary;
    }

    public byte[] getBinaryValue() {
        return this.getBinaryValue(null);
    }

    public byte[] getBinaryValue(byte[] result2) {
        if (this.isBinary || this.fieldsData instanceof byte[]) {
            return (byte[])this.fieldsData;
        }
        return null;
    }

    public int getBinaryLength() {
        if (this.isBinary) {
            return this.binaryLength;
        }
        if (this.fieldsData instanceof byte[]) {
            return ((byte[])this.fieldsData).length;
        }
        return 0;
    }

    public int getBinaryOffset() {
        return this.binaryOffset;
    }

    public boolean getOmitNorms() {
        return this.omitNorms;
    }

    @Deprecated
    public boolean getOmitTermFreqAndPositions() {
        return this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY;
    }

    public FieldInfo.IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    public void setOmitNorms(boolean omitNorms) {
        this.omitNorms = omitNorms;
    }

    @Deprecated
    public void setOmitTermFreqAndPositions(boolean omitTermFreqAndPositions) {
        this.indexOptions = omitTermFreqAndPositions ? FieldInfo.IndexOptions.DOCS_ONLY : FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
    }

    public void setIndexOptions(FieldInfo.IndexOptions indexOptions) {
        this.indexOptions = indexOptions;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public final String toString() {
        StringBuilder result2 = new StringBuilder();
        if (this.isStored) {
            result2.append("stored");
        }
        if (this.isIndexed) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("indexed");
        }
        if (this.isTokenized) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("tokenized");
        }
        if (this.storeTermVector) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("termVector");
        }
        if (this.storeOffsetWithTermVector) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("termVectorOffsets");
        }
        if (this.storePositionWithTermVector) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("termVectorPosition");
        }
        if (this.isBinary) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("binary");
        }
        if (this.omitNorms) {
            result2.append(",omitNorms");
        }
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
            result2.append(",indexOptions=");
            result2.append((Object)this.indexOptions);
        }
        if (this.lazy) {
            result2.append(",lazy");
        }
        result2.append('<');
        result2.append(this.name);
        result2.append(':');
        if (this.fieldsData != null && !this.lazy) {
            result2.append(this.fieldsData);
        }
        result2.append('>');
        return result2.toString();
    }
}

