/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import java.io.Serializable;
import java.nio.CharBuffer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class CharTermAttributeImpl
extends AttributeImpl
implements CharTermAttribute,
TermAttribute,
Cloneable,
Serializable {
    private static int MIN_BUFFER_SIZE = 10;
    private char[] termBuffer = new char[ArrayUtil.oversize(MIN_BUFFER_SIZE, 2)];
    private int termLength = 0;

    @Deprecated
    public String term() {
        return new String(this.termBuffer, 0, this.termLength);
    }

    public final void copyBuffer(char[] buffer, int offset2, int length2) {
        this.growTermBuffer(length2);
        System.arraycopy(buffer, offset2, this.termBuffer, 0, length2);
        this.termLength = length2;
    }

    @Deprecated
    public void setTermBuffer(char[] buffer, int offset2, int length2) {
        this.copyBuffer(buffer, offset2, length2);
    }

    @Deprecated
    public void setTermBuffer(String buffer) {
        int length2 = buffer.length();
        this.growTermBuffer(length2);
        buffer.getChars(0, length2, this.termBuffer, 0);
        this.termLength = length2;
    }

    @Deprecated
    public void setTermBuffer(String buffer, int offset2, int length2) {
        assert (offset2 <= buffer.length());
        assert (offset2 + length2 <= buffer.length());
        this.growTermBuffer(length2);
        buffer.getChars(offset2, offset2 + length2, this.termBuffer, 0);
        this.termLength = length2;
    }

    public final char[] buffer() {
        return this.termBuffer;
    }

    @Deprecated
    public char[] termBuffer() {
        return this.termBuffer;
    }

    public final char[] resizeBuffer(int newSize) {
        if (this.termBuffer.length < newSize) {
            char[] newCharBuffer = new char[ArrayUtil.oversize(newSize, 2)];
            System.arraycopy(this.termBuffer, 0, newCharBuffer, 0, this.termBuffer.length);
            this.termBuffer = newCharBuffer;
        }
        return this.termBuffer;
    }

    @Deprecated
    public char[] resizeTermBuffer(int newSize) {
        return this.resizeBuffer(newSize);
    }

    private void growTermBuffer(int newSize) {
        if (this.termBuffer.length < newSize) {
            this.termBuffer = new char[ArrayUtil.oversize(newSize, 2)];
        }
    }

    @Deprecated
    public int termLength() {
        return this.termLength;
    }

    public final CharTermAttribute setLength(int length2) {
        if (length2 > this.termBuffer.length) {
            throw new IllegalArgumentException("length " + length2 + " exceeds the size of the termBuffer (" + this.termBuffer.length + ")");
        }
        this.termLength = length2;
        return this;
    }

    public final CharTermAttribute setEmpty() {
        this.termLength = 0;
        return this;
    }

    @Deprecated
    public void setTermLength(int length2) {
        this.setLength(length2);
    }

    public final int length() {
        return this.termLength;
    }

    public final char charAt(int index2) {
        if (index2 >= this.termLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.termBuffer[index2];
    }

    public final CharSequence subSequence(int start2, int end2) {
        if (start2 > this.termLength || end2 > this.termLength) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.termBuffer, start2, end2 - start2);
    }

    public final CharTermAttribute append(CharSequence csq) {
        if (csq == null) {
            return this.appendNull();
        }
        return this.append(csq, 0, csq.length());
    }

    public final CharTermAttribute append(CharSequence csq, int start2, int end2) {
        if (csq == null) {
            csq = "null";
        }
        int len = end2 - start2;
        int csqlen = csq.length();
        if (len < 0 || start2 > csqlen || end2 > csqlen) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        this.resizeBuffer(this.termLength + len);
        if (len > 4) {
            if (csq instanceof String) {
                ((String)csq).getChars(start2, end2, this.termBuffer, this.termLength);
            } else if (csq instanceof StringBuilder) {
                ((StringBuilder)csq).getChars(start2, end2, this.termBuffer, this.termLength);
            } else if (csq instanceof CharTermAttribute) {
                System.arraycopy(((CharTermAttribute)csq).buffer(), start2, this.termBuffer, this.termLength, len);
            } else if (csq instanceof CharBuffer && ((CharBuffer)csq).hasArray()) {
                CharBuffer cb = (CharBuffer)csq;
                System.arraycopy(cb.array(), cb.arrayOffset() + cb.position() + start2, this.termBuffer, this.termLength, len);
            } else if (csq instanceof StringBuffer) {
                ((StringBuffer)csq).getChars(start2, end2, this.termBuffer, this.termLength);
            } else {
                while (start2 < end2) {
                    this.termBuffer[this.termLength++] = csq.charAt(start2++);
                }
                return this;
            }
            this.termLength += len;
            return this;
        }
        while (start2 < end2) {
            this.termBuffer[this.termLength++] = csq.charAt(start2++);
        }
        return this;
    }

    public final CharTermAttribute append(char c) {
        this.resizeBuffer((int)(this.termLength + 1))[this.termLength++] = c;
        return this;
    }

    public final CharTermAttribute append(String s2) {
        if (s2 == null) {
            return this.appendNull();
        }
        int len = s2.length();
        s2.getChars(0, len, this.resizeBuffer(this.termLength + len), this.termLength);
        this.termLength += len;
        return this;
    }

    public final CharTermAttribute append(StringBuilder s2) {
        if (s2 == null) {
            return this.appendNull();
        }
        int len = s2.length();
        s2.getChars(0, len, this.resizeBuffer(this.termLength + len), this.termLength);
        this.termLength += len;
        return this;
    }

    public final CharTermAttribute append(CharTermAttribute ta) {
        if (ta == null) {
            return this.appendNull();
        }
        int len = ta.length();
        System.arraycopy(ta.buffer(), 0, this.resizeBuffer(this.termLength + len), this.termLength, len);
        this.termLength += len;
        return this;
    }

    private CharTermAttribute appendNull() {
        this.resizeBuffer(this.termLength + 4);
        this.termBuffer[this.termLength++] = 110;
        this.termBuffer[this.termLength++] = 117;
        this.termBuffer[this.termLength++] = 108;
        this.termBuffer[this.termLength++] = 108;
        return this;
    }

    public int hashCode() {
        int code = this.termLength;
        code = code * 31 + ArrayUtil.hashCode(this.termBuffer, 0, this.termLength);
        return code;
    }

    public void clear() {
        this.termLength = 0;
    }

    public Object clone() {
        CharTermAttributeImpl t = (CharTermAttributeImpl)super.clone();
        t.termBuffer = new char[this.termLength];
        System.arraycopy(this.termBuffer, 0, t.termBuffer, 0, this.termLength);
        return t;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CharTermAttributeImpl) {
            CharTermAttributeImpl o = (CharTermAttributeImpl)other;
            if (this.termLength != o.termLength) {
                return false;
            }
            for (int i2 = 0; i2 < this.termLength; ++i2) {
                if (this.termBuffer[i2] == o.termBuffer[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return new String(this.termBuffer, 0, this.termLength);
    }

    public void reflectWith(AttributeReflector reflector) {
        reflector.reflect(CharTermAttribute.class, "term", this.toString());
    }

    public void copyTo(AttributeImpl target) {
        if (target instanceof CharTermAttribute) {
            CharTermAttribute t = (CharTermAttribute)((Object)target);
            t.copyBuffer(this.termBuffer, 0, this.termLength);
        } else {
            TermAttribute t = (TermAttribute)((Object)target);
            t.setTermBuffer(this.termBuffer, 0, this.termLength);
        }
    }
}

