/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Version;

public class StandardFilter
extends TokenFilter {
    private final Version matchVersion;
    private static final String APOSTROPHE_TYPE = ClassicTokenizer.TOKEN_TYPES[1];
    private static final String ACRONYM_TYPE = ClassicTokenizer.TOKEN_TYPES[2];
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    @Deprecated
    public StandardFilter(TokenStream in) {
        this(Version.LUCENE_30, in);
    }

    public StandardFilter(Version matchVersion, TokenStream in) {
        super(in);
        this.matchVersion = matchVersion;
    }

    public final boolean incrementToken() throws IOException {
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            return this.input.incrementToken();
        }
        return this.incrementTokenClassic();
    }

    public final boolean incrementTokenClassic() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] buffer = this.termAtt.buffer();
        int bufferLength = this.termAtt.length();
        String type2 = this.typeAtt.type();
        if (type2 == APOSTROPHE_TYPE && bufferLength >= 2 && buffer[bufferLength - 2] == '\'' && (buffer[bufferLength - 1] == 's' || buffer[bufferLength - 1] == 'S')) {
            this.termAtt.setLength(bufferLength - 2);
        } else if (type2 == ACRONYM_TYPE) {
            int upto2 = 0;
            for (int i2 = 0; i2 < bufferLength; ++i2) {
                char c = buffer[i2];
                if (c == '.') continue;
                buffer[upto2++] = c;
            }
            this.termAtt.setLength(upto2);
        }
        return true;
    }
}

