/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.reverse;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.Version;

public final class ReverseStringFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final char marker;
    private final Version matchVersion;
    private static final char NOMARKER = '\uffff';
    public static final char START_OF_HEADING_MARKER = '\u0001';
    public static final char INFORMATION_SEPARATOR_MARKER = '\u001f';
    public static final char PUA_EC00_MARKER = '\uec00';
    public static final char RTL_DIRECTION_MARKER = '\u200f';

    @Deprecated
    public ReverseStringFilter(TokenStream in) {
        this(in, '\uffff');
    }

    @Deprecated
    public ReverseStringFilter(TokenStream in, char marker) {
        this(Version.LUCENE_30, in, marker);
    }

    public ReverseStringFilter(Version matchVersion, TokenStream in) {
        this(matchVersion, in, '\uffff');
    }

    public ReverseStringFilter(Version matchVersion, TokenStream in, char marker) {
        super(in);
        this.matchVersion = matchVersion;
        this.marker = marker;
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            int len = this.termAtt.length();
            if (this.marker != '\uffff') {
                this.termAtt.resizeBuffer(++len);
                this.termAtt.buffer()[len - 1] = this.marker;
            }
            ReverseStringFilter.reverse(this.matchVersion, this.termAtt.buffer(), 0, len);
            this.termAtt.setLength(len);
            return true;
        }
        return false;
    }

    @Deprecated
    public static String reverse(String input) {
        return ReverseStringFilter.reverse(Version.LUCENE_30, input);
    }

    public static String reverse(Version matchVersion, String input) {
        char[] charInput = input.toCharArray();
        ReverseStringFilter.reverse(matchVersion, charInput, 0, charInput.length);
        return new String(charInput);
    }

    @Deprecated
    public static void reverse(char[] buffer) {
        ReverseStringFilter.reverse(buffer, 0, buffer.length);
    }

    public static void reverse(Version matchVersion, char[] buffer) {
        ReverseStringFilter.reverse(matchVersion, buffer, 0, buffer.length);
    }

    @Deprecated
    public static void reverse(char[] buffer, int len) {
        ReverseStringFilter.reverse(buffer, 0, len);
    }

    public static void reverse(Version matchVersion, char[] buffer, int len) {
        ReverseStringFilter.reverse(matchVersion, buffer, 0, len);
    }

    @Deprecated
    public static void reverse(char[] buffer, int start2, int len) {
        ReverseStringFilter.reverseUnicode3(buffer, start2, len);
    }

    @Deprecated
    private static void reverseUnicode3(char[] buffer, int start2, int len) {
        if (len <= 1) {
            return;
        }
        int num = len >> 1;
        for (int i2 = start2; i2 < start2 + num; ++i2) {
            char c = buffer[i2];
            buffer[i2] = buffer[start2 * 2 + len - i2 - 1];
            buffer[start2 * 2 + len - i2 - 1] = c;
        }
    }

    public static void reverse(Version matchVersion, char[] buffer, int start2, int len) {
        if (!matchVersion.onOrAfter(Version.LUCENE_31)) {
            ReverseStringFilter.reverseUnicode3(buffer, start2, len);
            return;
        }
        if (len < 2) {
            return;
        }
        int end2 = start2 + len - 1;
        char frontHigh = buffer[start2];
        char endLow = buffer[end2];
        boolean allowFrontSur = true;
        boolean allowEndSur = true;
        int mid = start2 + (len >> 1);
        int i2 = start2;
        while (i2 < mid) {
            boolean surAtFront;
            char frontLow = buffer[i2 + 1];
            char endHigh = buffer[end2 - 1];
            boolean bl = surAtFront = allowFrontSur && Character.isSurrogatePair(frontHigh, frontLow);
            if (surAtFront && len < 3) {
                return;
            }
            boolean surAtEnd = allowEndSur && Character.isSurrogatePair(endHigh, endLow);
            allowEndSur = true;
            allowFrontSur = true;
            if (surAtFront == surAtEnd) {
                if (surAtFront) {
                    buffer[end2] = frontLow;
                    buffer[--end2] = frontHigh;
                    buffer[i2] = endHigh;
                    buffer[++i2] = endLow;
                    frontHigh = buffer[i2 + 1];
                    endLow = buffer[end2 - 1];
                } else {
                    buffer[end2] = frontHigh;
                    buffer[i2] = endLow;
                    frontHigh = frontLow;
                    endLow = endHigh;
                }
            } else if (surAtFront) {
                buffer[end2] = frontLow;
                buffer[i2] = endLow;
                endLow = endHigh;
                allowFrontSur = false;
            } else {
                buffer[end2] = frontHigh;
                buffer[i2] = endHigh;
                frontHigh = frontLow;
                allowEndSur = false;
            }
            ++i2;
            --end2;
        }
        if (!((len & 1) != 1 || allowFrontSur && allowEndSur)) {
            buffer[end2] = allowFrontSur ? endLow : frontHigh;
        }
    }
}

