/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

public class PayloadHelper {
    public static byte[] encodeFloat(float payload) {
        return PayloadHelper.encodeFloat(payload, new byte[4], 0);
    }

    public static byte[] encodeFloat(float payload, byte[] data2, int offset2) {
        return PayloadHelper.encodeInt(Float.floatToIntBits(payload), data2, offset2);
    }

    public static byte[] encodeInt(int payload) {
        return PayloadHelper.encodeInt(payload, new byte[4], 0);
    }

    public static byte[] encodeInt(int payload, byte[] data2, int offset2) {
        data2[offset2] = (byte)(payload >> 24);
        data2[offset2 + 1] = (byte)(payload >> 16);
        data2[offset2 + 2] = (byte)(payload >> 8);
        data2[offset2 + 3] = (byte)payload;
        return data2;
    }

    public static float decodeFloat(byte[] bytes2) {
        return PayloadHelper.decodeFloat(bytes2, 0);
    }

    public static final float decodeFloat(byte[] bytes2, int offset2) {
        return Float.intBitsToFloat(PayloadHelper.decodeInt(bytes2, offset2));
    }

    public static final int decodeInt(byte[] bytes2, int offset2) {
        return (bytes2[offset2] & 0xFF) << 24 | (bytes2[offset2 + 1] & 0xFF) << 16 | (bytes2[offset2 + 2] & 0xFF) << 8 | bytes2[offset2 + 3] & 0xFF;
    }
}

