/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.PayloadEncoder;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;

public final class DelimitedPayloadTokenFilter
extends TokenFilter {
    public static final char DEFAULT_DELIMITER = '|';
    private final char delimiter;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final PayloadAttribute payAtt = this.addAttribute(PayloadAttribute.class);
    private final PayloadEncoder encoder;

    public DelimitedPayloadTokenFilter(TokenStream input, char delimiter, PayloadEncoder encoder) {
        super(input);
        this.delimiter = delimiter;
        this.encoder = encoder;
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length2 = this.termAtt.length();
            for (int i2 = 0; i2 < length2; ++i2) {
                if (buffer[i2] != this.delimiter) continue;
                this.payAtt.setPayload(this.encoder.encode(buffer, i2 + 1, length2 - (i2 + 1)));
                this.termAtt.setLength(i2);
                return true;
            }
            this.payAtt.setPayload(null);
            return true;
        }
        return false;
    }
}

