/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.path;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public class PathHierarchyTokenizer
extends Tokenizer {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final char DEFAULT_DELIMITER = '/';
    public static final int DEFAULT_SKIP = 0;
    private final char delimiter;
    private final char replacement;
    private final int skip;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posAtt = this.addAttribute(PositionIncrementAttribute.class);
    private int startPosition = 0;
    private int skipped = 0;
    private boolean endDelimiter = false;
    private StringBuilder resultToken;
    private int charsRead = 0;

    public PathHierarchyTokenizer(Reader input) {
        this(input, 1024, '/', '/', 0);
    }

    public PathHierarchyTokenizer(Reader input, int skip2) {
        this(input, 1024, '/', '/', skip2);
    }

    public PathHierarchyTokenizer(Reader input, int bufferSize, char delimiter) {
        this(input, bufferSize, delimiter, delimiter, 0);
    }

    public PathHierarchyTokenizer(Reader input, char delimiter, char replacement2) {
        this(input, 1024, delimiter, replacement2, 0);
    }

    public PathHierarchyTokenizer(Reader input, char delimiter, char replacement2, int skip2) {
        this(input, 1024, delimiter, replacement2, skip2);
    }

    public PathHierarchyTokenizer(Reader input, int bufferSize, char delimiter, char replacement2, int skip2) {
        super(input);
        if (bufferSize < 0) {
            throw new IllegalArgumentException("bufferSize cannot be negative");
        }
        if (skip2 < 0) {
            throw new IllegalArgumentException("skip cannot be negative");
        }
        this.termAtt.resizeBuffer(bufferSize);
        this.delimiter = delimiter;
        this.replacement = replacement2;
        this.skip = skip2;
        this.resultToken = new StringBuilder(bufferSize);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.termAtt.append(this.resultToken);
        if (this.resultToken.length() == 0) {
            this.posAtt.setPositionIncrement(1);
        } else {
            this.posAtt.setPositionIncrement(0);
        }
        int length2 = 0;
        boolean added = false;
        if (this.endDelimiter) {
            this.termAtt.append(this.replacement);
            ++length2;
            this.endDelimiter = false;
            added = true;
        }
        while (true) {
            int c;
            if ((c = this.input.read()) >= 0) {
                ++this.charsRead;
            } else {
                if (this.skipped > this.skip) {
                    this.termAtt.setLength(length2 += this.resultToken.length());
                    this.offsetAtt.setOffset(this.correctOffset(this.startPosition), this.correctOffset(this.startPosition + length2));
                    if (added) {
                        this.resultToken.setLength(0);
                        this.resultToken.append(this.termAtt.buffer(), 0, length2);
                    }
                    return added;
                }
                return false;
            }
            if (!added) {
                added = true;
                ++this.skipped;
                if (this.skipped > this.skip) {
                    this.termAtt.append(c == this.delimiter ? this.replacement : (char)c);
                    ++length2;
                    continue;
                }
                ++this.startPosition;
                continue;
            }
            if (c == this.delimiter) {
                if (this.skipped > this.skip) break;
                ++this.skipped;
                if (this.skipped > this.skip) {
                    this.termAtt.append(this.replacement);
                    ++length2;
                    continue;
                }
                ++this.startPosition;
                continue;
            }
            if (this.skipped > this.skip) {
                this.termAtt.append((char)c);
                ++length2;
                continue;
            }
            ++this.startPosition;
        }
        this.endDelimiter = true;
        this.termAtt.setLength(length2 += this.resultToken.length());
        this.offsetAtt.setOffset(this.correctOffset(this.startPosition), this.correctOffset(this.startPosition + length2));
        this.resultToken.setLength(0);
        this.resultToken.append(this.termAtt.buffer(), 0, length2);
        return true;
    }

    public final void end() {
        int finalOffset = this.correctOffset(this.charsRead);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public void reset() throws IOException {
        super.reset();
        this.resultToken.setLength(0);
        this.charsRead = 0;
        this.endDelimiter = false;
        this.skipped = 0;
        this.startPosition = 0;
    }
}

