/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.hunspell.HunspellAffix;
import org.apache.lucene.analysis.hunspell.HunspellDictionary;
import org.apache.lucene.analysis.hunspell.HunspellWord;
import org.apache.lucene.util.CharacterUtils;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HunspellStemmer {
    private static final int RECURSION_CAP = 2;
    private final HunspellDictionary dictionary;
    private final StringBuilder segment = new StringBuilder();
    private CharacterUtils charUtils = CharacterUtils.getInstance(Version.LUCENE_34);

    public HunspellStemmer(HunspellDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public List<Stem> stem(String word) {
        return this.stem(word.toCharArray(), word.length());
    }

    public List<Stem> stem(char[] word, int length2) {
        ArrayList<Stem> stems = new ArrayList<Stem>();
        if (this.dictionary.lookupWord(word, 0, length2) != null) {
            stems.add(new Stem(word, length2));
        }
        stems.addAll(this.stem(word, length2, null, 0));
        return stems;
    }

    public List<Stem> uniqueStems(char[] word, int length2) {
        ArrayList<Stem> stems = new ArrayList<Stem>();
        CharArraySet terms = new CharArraySet(this.dictionary.getVersion(), 8, this.dictionary.isIgnoreCase());
        if (this.dictionary.lookupWord(word, 0, length2) != null) {
            stems.add(new Stem(word, length2));
            terms.add(word);
        }
        List<Stem> otherStems = this.stem(word, length2, null, 0);
        for (Stem s2 : otherStems) {
            if (terms.contains(s2.stem)) continue;
            stems.add(s2);
            terms.add(s2.stem);
        }
        return stems;
    }

    private List<Stem> stem(char[] word, int length2, char[] flags, int recursionDepth) {
        int i2;
        ArrayList<Stem> stems = new ArrayList<Stem>();
        for (i2 = 0; i2 < length2; ++i2) {
            List<HunspellAffix> suffixes = this.dictionary.lookupSuffix(word, i2, length2 - i2);
            if (suffixes == null) continue;
            for (HunspellAffix suffix : suffixes) {
                if (!this.hasCrossCheckedFlag(suffix.getFlag(), flags)) continue;
                int deAffixedLength = length2 - suffix.getAppend().length();
                String strippedWord = new StringBuilder().append(word, 0, deAffixedLength).append(suffix.getStrip()).toString();
                List<Stem> stemList = this.applyAffix(strippedWord.toCharArray(), strippedWord.length(), suffix, recursionDepth);
                for (Stem stem : stemList) {
                    stem.addSuffix(suffix);
                }
                stems.addAll(stemList);
            }
        }
        for (i2 = length2 - 1; i2 >= 0; --i2) {
            List<HunspellAffix> prefixes = this.dictionary.lookupPrefix(word, 0, i2);
            if (prefixes == null) continue;
            for (HunspellAffix prefix : prefixes) {
                if (!this.hasCrossCheckedFlag(prefix.getFlag(), flags)) continue;
                int deAffixedStart = prefix.getAppend().length();
                int deAffixedLength = length2 - deAffixedStart;
                String strippedWord = new StringBuilder().append(prefix.getStrip()).append(word, deAffixedStart, deAffixedLength).toString();
                List<Stem> stemList = this.applyAffix(strippedWord.toCharArray(), strippedWord.length(), prefix, recursionDepth);
                for (Stem stem : stemList) {
                    stem.addPrefix(prefix);
                }
                stems.addAll(stemList);
            }
        }
        return stems;
    }

    public List<Stem> applyAffix(char[] strippedWord, int length2, HunspellAffix affix, int recursionDepth) {
        if (this.dictionary.isIgnoreCase()) {
            for (int i2 = 0; i2 < strippedWord.length; i2 += Character.toChars(Character.toLowerCase(this.charUtils.codePointAt(strippedWord, i2)), strippedWord, i2)) {
            }
        }
        this.segment.setLength(0);
        this.segment.append(strippedWord, 0, length2);
        if (!affix.checkCondition(this.segment)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Stem> stems = new ArrayList<Stem>();
        List<HunspellWord> words = this.dictionary.lookupWord(strippedWord, 0, length2);
        if (words != null) {
            for (HunspellWord hunspellWord : words) {
                if (!hunspellWord.hasFlag(affix.getFlag())) continue;
                stems.add(new Stem(strippedWord, length2));
            }
        }
        if (affix.isCrossProduct() && recursionDepth < 2) {
            stems.addAll(this.stem(strippedWord, length2, affix.getAppendFlags(), ++recursionDepth));
        }
        return stems;
    }

    private boolean hasCrossCheckedFlag(char flag, char[] flags) {
        return flags == null || Arrays.binarySearch(flags, flag) >= 0;
    }

    public static void main(String[] args2) throws IOException, ParseException {
        String word;
        boolean ignoreCase = false;
        int offset2 = 0;
        if (args2.length < 2) {
            System.out.println("usage: HunspellStemmer [-i] <affix location> <dic location>");
            System.exit(1);
        }
        if (args2[offset2].equals("-i")) {
            ignoreCase = true;
            System.out.println("Ignoring case. All stems will be returned lowercased");
        }
        int n = ++offset2;
        FileInputStream affixInputStream = new FileInputStream(args2[n]);
        int n2 = ++offset2;
        ++offset2;
        FileInputStream dicInputStream = new FileInputStream(args2[n2]);
        HunspellDictionary dictionary = new HunspellDictionary((InputStream)affixInputStream, dicInputStream, Version.LUCENE_34, ignoreCase);
        ((InputStream)affixInputStream).close();
        ((InputStream)dicInputStream).close();
        HunspellStemmer stemmer = new HunspellStemmer(dictionary);
        Scanner scanner = new Scanner(System.in);
        System.out.print("> ");
        while (scanner.hasNextLine() && !"exit".equals(word = scanner.nextLine())) {
            HunspellStemmer.printStemResults(word, stemmer.stem(word.toCharArray(), word.length()));
            System.out.print("> ");
        }
    }

    private static void printStemResults(String originalWord, List<Stem> stems) {
        StringBuilder builder = new StringBuilder().append("stem(").append(originalWord).append(")").append("\n");
        for (Stem stem : stems) {
            builder.append("- ").append(stem.getStem()).append(": ");
            for (HunspellAffix prefix : stem.getPrefixes()) {
                builder.append(prefix.getAppend()).append("+");
                if (!HunspellStemmer.hasText(prefix.getStrip())) continue;
                builder.append(prefix.getStrip()).append("-");
            }
            builder.append(stem.getStem());
            for (HunspellAffix suffix : stem.getSuffixes()) {
                if (HunspellStemmer.hasText(suffix.getStrip())) {
                    builder.append("-").append(suffix.getStrip());
                }
                builder.append("+").append(suffix.getAppend());
            }
            builder.append("\n");
        }
        System.out.println(builder);
    }

    private static boolean hasText(String str) {
        return str != null && str.length() > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Stem {
        private final List<HunspellAffix> prefixes = new ArrayList<HunspellAffix>();
        private final List<HunspellAffix> suffixes = new ArrayList<HunspellAffix>();
        private final char[] stem;
        private final int stemLength;

        public Stem(char[] stem, int stemLength) {
            this.stem = stem;
            this.stemLength = stemLength;
        }

        public void addPrefix(HunspellAffix prefix) {
            this.prefixes.add(0, prefix);
        }

        public void addSuffix(HunspellAffix suffix) {
            this.suffixes.add(suffix);
        }

        public List<HunspellAffix> getPrefixes() {
            return this.prefixes;
        }

        public List<HunspellAffix> getSuffixes() {
            return this.suffixes;
        }

        public char[] getStem() {
            return this.stem;
        }

        public int getStemLength() {
            return this.stemLength;
        }

        public String getStemString() {
            return new String(this.stem, 0, this.stemLength);
        }
    }
}

